package cn.lili.modules.promotion.client;

import cn.lili.modules.constant.ServiceConstant;
import cn.lili.modules.promotion.entity.dos.CouponActivity;
import cn.lili.modules.promotion.entity.dos.MemberCoupon;
import cn.lili.modules.promotion.entity.dto.CouponActivityTrigger;
import cn.lili.modules.promotion.entity.vos.CouponActivityVO;
import cn.lili.modules.promotion.fallback.CouponActivityFallback;
import cn.lili.modules.store.entity.dos.Store;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * @author: ftyy
 * @date: 2022-01-13 18:11
 * @description: 优惠券活动Client
 */
@FeignClient(
        name = ServiceConstant.PROMOTION_SERVICE,
        contextId = "coupon-activity",
        fallback = CouponActivityFallback.class)
public interface CouponActivityClient {

    /**
     * 获取优惠券活动VO 包含优惠券活动信息以及优惠券关联优惠券列表
     *
     * @param couponActivityId 优惠券活动ID
     * @return 优惠券VO
     */
    @GetMapping("/feign/promotion/coupon-activity/getCouponActivityVO/{couponActivityId}")
    CouponActivityVO getCouponActivityVO(@PathVariable String couponActivityId);

    /**
     * 优惠券活动列表
     *
     * @return
     */
    @GetMapping("/feign/promotion/coupon-activity/list")
    List<CouponActivity> list();

    @PostMapping("/feign/promotion/coupon-activity/trigger")
    List<MemberCoupon> trigger(@RequestBody CouponActivityTrigger couponActivityTrigger);

    /**
     * 修改优惠券活动中店铺名称
     *
     * @param store 店铺信息
     */
    @PutMapping("/feign/promotion/coupon-activity/updateStoreName")
    void updateStoreName(@RequestBody Store store);
}
