package cn.lili.modules.promotion.client;

import cn.lili.modules.constant.ServiceConstant;
import cn.lili.modules.promotion.fallback.CouponFallback;
import cn.lili.modules.store.entity.dos.Store;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;

/**
 * @author ftyy
 * @description: 优惠券Client
 * @date 2023/4/24
 */
@FeignClient(
        name = ServiceConstant.PROMOTION_SERVICE,
        contextId = "coupon",
        fallback = CouponFallback.class)
public interface CouponClient {
    /**
     * 修改优惠券中店铺名称
     *
     * @param store 店铺信息
     */
    @PutMapping("/feign/promotion/coupon/updateStoreName")
    void updateStoreName(@RequestBody Store store);
}
