package cn.lili.modules.promotion.client;


import cn.lili.modules.constant.ServiceConstant;
import cn.lili.modules.promotion.fallback.CouponFallback;
import cn.lili.modules.store.entity.dos.Store;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;

/**
 * @author ftyy
 * @description: 秒杀活动申请Client
 * @date 2023/4/24
 */
@FeignClient(
        name = ServiceConstant.PROMOTION_SERVICE,
        contextId = "seckill-apply",
        fallback = CouponFallback.class)
public interface SeckillApplyClient {
    /**
     * 修改秒杀活动中店铺名称
     *
     * @param store 店铺信息
     */
    @PutMapping("/feign/promotion/seckill-apply/updateStoreName")
    void updateStoreName(@RequestBody Store store);
}
