package cn.lili.modules.promotion.client;

import cn.lili.modules.constant.ServiceConstant;
import cn.lili.modules.promotion.fallback.SeckillStatisticsFallback;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;

/**
 * @author paulG
 * @since 2022/6/28
 **/
@FeignClient(name = ServiceConstant.PROMOTION_SERVICE, contextId = "seckill-statistics", fallback = SeckillStatisticsFallback.class)
public interface SeckillStatisticsClient {


    /**
     * 获取当前可参与的活动数量
     *
     * @return 可参与活动数量
     */
    @PostMapping("/feign/promotion/seckill/statistics")
    long getApplyNum();

}
