package cn.lili.modules.store.client;

import cn.lili.modules.constant.ServiceConstant;
import cn.lili.modules.store.fallback.BillStatisticsFallback;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

/**
 * @author paulG
 * @since 2022/6/24
 **/
@FeignClient(
        name = ServiceConstant.PAYMENT_SERVICE,
        contextId = "bill-statistics",
        fallback = BillStatisticsFallback.class)
public interface BillStatisticsClient {


    /**
     * 商家待结算数量
     *
     * @param billStatusEnum 结算单类型
     * @param storeId      商家ID
     * @return 待结算商家数量
     */
    @PostMapping("/feign/store/bill/statistics")
    long billNum(@RequestParam String billStatusEnum, @RequestParam String storeId);
}
