package cn.lili.modules.store.client;

import cn.lili.modules.constant.ServiceConstant;
import cn.lili.modules.store.entity.dos.StoreAddress;
import cn.lili.modules.store.fallback.StoreAddressFallback;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;

/**
 * @author: ftyy
 * @date: 2021-12-25 17:56
 * @description: 店铺自提点Client
 */
@FeignClient(
        name = ServiceConstant.MEMBER_SERVICE,
        contextId = "storeAddress",
        fallback = StoreAddressFallback.class)
public interface StoreAddressClient {

    /**
     * 根据id获取
     *
     * @param id
     * @return
     */
    @GetMapping("/feign/store/storeAddress/getById/{id}")
    StoreAddress getById(@PathVariable String id);

    /**
     * 添加
     *
     * @param storeAddress
     * @return
     */
    @PostMapping("/feign/store/storeAddress/save")
    Boolean save(@RequestBody StoreAddress storeAddress);

    /**
     * 修改
     *
     * @param storeAddress
     * @return
     */
    @PutMapping("/feign/store/storeAddress/updateById")
    Boolean updateById(@RequestBody StoreAddress storeAddress);

    /**
     * 删除商家自提点
     *
     * @param id 自提点ID
     * @return 操作状态
     */
    @GetMapping("/feign/store/storeAddress/removeStoreAddress/{id}")
    Boolean removeStoreAddress(@PathVariable String id);
}
