package cn.lili.modules.store.client;


import cn.lili.modules.constant.ServiceConstant;
import cn.lili.modules.store.entity.dos.StoreDetail;
import cn.lili.modules.store.fallback.StoreDetailFallback;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;

import java.util.List;

/**
 * @author: ftyy
 * @description: 店铺-店铺详细
 */
@FeignClient(name = ServiceConstant.MEMBER_SERVICE, contextId = "storeDetail", fallback = StoreDetailFallback.class)
public interface StoreDetailClient {


    /**
     * 获取店铺详细列表
     *
     * @return 店铺详细列表
     */
    @GetMapping("/feign/storeDetail/getList")
    List<StoreDetail> getList();
}
