package cn.lili.modules.system.client;

import cn.lili.modules.constant.ServiceConstant;
import cn.lili.modules.permission.entity.dos.AdminUser;
import cn.lili.modules.permission.entity.dto.AdminUserDTO;
import cn.lili.modules.system.fallback.AdminUserFallback;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;

import java.util.List;


@FeignClient(name = ServiceConstant.SYSTEM_SERVICE, contextId = "admin-user",fallback = AdminUserFallback.class)
public interface AdminUserClient {


    /**
     * 查找管理员信息
     *
     */
    @PostMapping("/feign/admin-user/find")
    List<AdminUserDTO> find(@RequestBody List<String> ids);

    @GetMapping("/feign/admin-user/findByUsername/{username}")
    AdminUser findByUsername(@PathVariable String username);

    @GetMapping("/feign/admin-user/findById/{id}")
    AdminUser findById(@PathVariable String id);


}
