package cn.lili.modules.system.client;

import cn.lili.modules.constant.ServiceConstant;
import cn.lili.modules.system.fallback.SensitiveWordsFallback;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;

/**
 * 敏感词Client
 *
 * @author paulG
 * @since 2021/12/17
 **/
@FeignClient(name = ServiceConstant.SYSTEM_SERVICE, contextId = "sensitive-words", fallback = SensitiveWordsFallback.class)
public interface SensitiveWordsClient {

    /**
     * 重新写入缓存
     */
    @GetMapping("/feign/sensitive-words/reset-cache")
    void resetCache();

}

