package cn.lili.modules.system.entity.params;

import cn.lili.modules.verification.entity.enums.VerificationEnums;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.List;
import java.util.Map;

/**
 * @author: ftyy
 * @date: 2022-01-19 16:15
 * @description: 短信
 */
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class SmsParams {

    @ApiModelProperty(value = "手机号")
    private String mobile;

    @ApiModelProperty(value = "手机号集合")
    private List<String> mobiles;

    @ApiModelProperty(value = "模版code")
    private String templateCode;

    @ApiModelProperty(value = "参数")
    private Map<String, String> param;

    @ApiModelProperty(value = "签名名称")
    private String signName;

    @ApiModelProperty(value = "验证码")
    private String code;

    @ApiModelProperty(value = "uuid")
    private String uuid;

    @ApiModelProperty(value = "短信类型")
    private VerificationEnums verificationEnums;

    public SmsParams(String mobile, VerificationEnums verificationEnums, String uuid, String code) {
        this.mobile = mobile;
        this.code = code;
        this.uuid = uuid;
        this.verificationEnums = verificationEnums;
    }
}
