package cn.lili.modules.verification.client;

import cn.lili.modules.constant.ServiceConstant;
import cn.lili.modules.verification.entity.enums.VerificationEnums;
import cn.lili.modules.verification.fallback.VerificationServiceFallback;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

/**
 * 验证码 client
 *
 * @author Chopper
 * @version v1.0
 * 2021-11-08 09:52
 */
@FeignClient(name = ServiceConstant.SYSTEM_SERVICE, contextId = "verification",fallback = VerificationServiceFallback.class)
public interface VerificationServiceClient {

    /**
     * 校验验证码
     *
     * @param verificationEnums 验证枚举
     * @param uuid              uuid
     * @return 校验结果
     */
    @PostMapping("/feign/verification/{uuid}")
    boolean check(@PathVariable String uuid,@RequestBody VerificationEnums verificationEnums);
}
