package cn.lili.modules.verification.entity.dos;

import cn.lili.modules.verification.entity.enums.VerificationSourceEnum;
import cn.lili.mybatis.BaseEntity;
import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * 验证码资源维护
 *
 * @author Chopper
 * @since 2021/1/30 4:13 下午
 */
@Data
@TableName("li_verification_source")
@ApiModel(value = "验证码资源维护")
@EqualsAndHashCode(callSuper = true)
public class VerificationSource extends BaseEntity {

    private static final long serialVersionUID = -755266084786981030L;

    @ApiModelProperty(value = "名称")
    private String name;

    @ApiModelProperty(value = "资源地址")
    private String resource;

    /**
     * @see VerificationSourceEnum
     */
    @ApiModelProperty(value = "验证码资源类型 SLIDER/SOURCE")
    private String type;
}