package cn.lili.modules.wechat.client;

import cn.lili.modules.constant.ServiceConstant;
import cn.lili.modules.wechat.entity.dos.WechatMPMessage;
import cn.lili.modules.wechat.fallback.WechatMPMessageFallback;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;

import java.util.List;

@FeignClient(name = ServiceConstant.SYSTEM_SERVICE, contextId = "wechatMPMessage", fallback = WechatMPMessageFallback.class)
public interface WechatMPMessageClient {

    /**
     * 消息订阅
     * @return
     */
    @GetMapping("/feign/wechatMPMessage/list")
    List<WechatMPMessage> list();
}
