package cn.lili.modules.wechat.entity.dto.applyments;

import cn.lili.modules.wechat.entity.SpecEncrypt;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * 结算账户信息
 * 请填写商家提现收款的银行账户信息
 *
 * @author Bulbasaur
 */
@Data
public class AccountInfo {
    /**
     * 1、若主体为企业/政府机关/事业单位/社会组织，可填写：74-对公账户。
     * 2、主体为小微/个人卖家，可选择：75-对私账户。
     * 3、若主体为个体工商户，可填写：74-对公账户、75-对私账户。
     */
    @ApiModelProperty(value = "账户类型")
    String bank_account_type;

    /**
     * 对私银行调用：查询支持个人业务的银行列表API
     * 对公银行调用：查询支持对公业务的银行列表API。
     */
    @ApiModelProperty(value = "开户银行")
    String account_bank;

    /**
     * 1、选择经营者个人银行卡时，开户名称必须与身份证姓名一致。
     * 2、选择对公账户时，开户名称必须与营业执照上的“商户名称”一致。
     * 3、该字段需进行加密处理，加密方法详见敏感信息加密说明。(提醒：必须在HTTP头中上送Wechatpay-Serial)
     */
    @ApiModelProperty(value = "开户名称")
    @SpecEncrypt
    String account_name;

    /**
     * 至少精确到市，详细参见省市区编号对照表。
     * 注：
     * 仅当省市区编号对照表中无对应的省市区编号时，可向上取该银行对应市级编号或省级编号。
     */
    @ApiModelProperty(value = "开户银行省市编码")
    String bank_address_code;

    /**
     * 1、根据开户银行查询接口中的“是否需要填写支行”判断是否需要填写。如为其他银行，开户银行全称（含支行）和开户银行联行号二选一。
     * 2、详细需调用查询支行列表API查看查询结果。
     */
    @ApiModelProperty(value = "开户银行联行号")
    String bank_branch_id;

    /**
     * 1、根据开户银行查询接口中的“是否需要填写支行”判断是否需要填写。如为其他银行，开户银行全称（含支行）和开户银行联行号二选一。
     * 2、详细需调用查询支行列表API查看查询结果。
     */
    @ApiModelProperty(value = "开户银行全称 （含支行）")
    String bank_name;

    /**
     * 1、数字，长度遵循系统支持的对公/对私卡号长度要求表。
     * 2、该字段需进行加密处理，加密方法详见敏感信息加密说明。(提醒：必须在HTTP头中上送Wechatpay-Serial)
     */
    @SpecEncrypt
    @ApiModelProperty(value = "银行账号")
    String account_number;
}

