package cn.lili.modules.wechat.entity.dto.applyments;

import cn.lili.modules.wechat.entity.SpecEncrypt;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * 经营者/法人其他类型证件信息
 * 当证件持有人类型为经营者/法人且证件类型不为“身份证”时填写。
 *
 * @author Bulbasaur
 */
@Data
public class IdDocInfo {

    /**
     * 1、证件类型不为“身份证”时，上传证件正面照片。
     * 2、可上传1张图片，请填写通过图片图片上传API预先上传图片生成好的MediaID。
     * 3、请上传彩色照片or彩色扫描件or复印件（需加盖公章鲜章），可添加“微信支付”相关水印（如微信支付认证）。
     */
    @ApiModelProperty(value = "证件正面照片")
    String id_doc_copy;

    /**
     * 1、若证件类型为来往通行证、外国人居留证、港澳居住证、台湾居住证时，上传证件反面照片。
     * 2、若证件类型为护照，无需上传反面照片。
     * 3、可上传1张图片，请填写通过图片上传API预先上传图片生成好的MediaID 。
     * 4、请上传彩色照片or彩色扫描件or复印件（需加盖公章鲜章），可添加“微信支付”相关水印（如微信支付认证）。
     */
    @ApiModelProperty(value = "证件反面照片")
    String id_doc_copy_back;

    /**
     * 1、请填写经营者/法人姓名。
     * 2、该字段需进行加密处理，加密方法详见敏感信息加密说明。(提醒：必须在HTTP头中上送Wechatpay-Serial)
     */
    @ApiModelProperty(value = "证件姓名")
    @SpecEncrypt
    String id_doc_name;

    /**
     * 7~11位 数字|字母|连字符 。
     * 该字段需进行加密处理，加密方法详见敏感信息加密说明。(提醒：必须在HTTP头中上送Wechatpay-Serial)
     */
    @ApiModelProperty(value = "证件号码")
    @SpecEncrypt
    String id_doc_number;

    /**
     * 1、主体类型为企业时，需要填写。其他主体类型，无需上传。
     * 2、请按照证件上住址填写，若证件上无住址则按照实际住址填写，如广东省深圳市南山区xx路xx号xx室。
     * 3、该字段需进行加密处理，加密方法详见敏感信息加密说明。(提醒：必须在HTTP头中上送Wechatpay-Serial)
     */
    @ApiModelProperty(value = "证件居住地址")
    @SpecEncrypt
    String id_doc_address;

    /**
     * 1、请按照示例值填写
     * 2、结束时间大于开始时间
     */
    @ApiModelProperty(value = "证件有效期开始时间")
    String doc_period_begin;

    /**
     * 1、请按照示例值填写，若证件有效期为长期，请填写：长期。
     * 2、结束时间大于开始时间。
     */
    @ApiModelProperty(value = "证件有效期结束时间")
    String doc_period_end;
}
