/*
 * Decompiled with CFR 0.152.
 */
package cn.lili.modules.connect.entity.enums;

import cn.lili.common.enums.ClientTypeEnum;
import cn.lili.modules.connect.entity.enums.ConnectEnum;

public enum SourceEnum {
    WECHAT_PC_OPEN_ID("\u5fae\u4fe1PC\u5e94\u7528 openid\u767b\u5f55"),
    WECHAT_OFFIACCOUNT_OPEN_ID("\u5fae\u4fe1\u516c\u4f17\u53f7 openid\u767b\u5f55"),
    WECHAT_MP_OPEN_ID("\u5fae\u4fe1\u5c0f\u7a0b\u5e8f openid\u767b\u5f55"),
    WECHAT_APP_OPEN_ID("\u5fae\u4fe1APP openid\u767b\u5f55"),
    QQ_APP_OPEN_ID("QQ APP openid\u767b\u5f55"),
    QQ_PC_OPEN_ID("QQ PC\u5e94\u7528 openid\u767b\u5f55"),
    QQ_H5_OPEN_ID("QQ H5\u5e94\u7528 openid\u767b\u5f55"),
    APPLE_OPEN_ID("\u82f9\u679c openid\u767b\u5f55");

    private final String description;

    private SourceEnum(String description) {
        this.description = description;
    }

    public static SourceEnum getSourceEnum(ConnectEnum source, ClientTypeEnum type) {
        switch (source) {
            case WECHAT: {
                switch (type) {
                    case APP: {
                        return WECHAT_APP_OPEN_ID;
                    }
                    case WECHAT_MP: {
                        return WECHAT_MP_OPEN_ID;
                    }
                    case PC: {
                        return WECHAT_PC_OPEN_ID;
                    }
                    case H5: {
                        return WECHAT_OFFIACCOUNT_OPEN_ID;
                    }
                }
                break;
            }
            case QQ: {
                switch (type) {
                    case APP: {
                        return QQ_APP_OPEN_ID;
                    }
                    case PC: {
                        return QQ_PC_OPEN_ID;
                    }
                    case H5: {
                        return QQ_H5_OPEN_ID;
                    }
                }
                break;
            }
            case APPLE: {
                return APPLE_OPEN_ID;
            }
        }
        return null;
    }
}

