/*
 * Decompiled with CFR 0.152.
 */
package cn.lili.modules.file.plugin.impl;

import cn.lili.common.enums.ResultCode;
import cn.lili.common.exception.ServiceException;
import cn.lili.modules.file.entity.enums.OssEnum;
import cn.lili.modules.file.plugin.FilePlugin;
import cn.lili.modules.system.entity.dto.OssSetting;
import com.aliyun.oss.ClientException;
import com.aliyun.oss.OSS;
import com.aliyun.oss.OSSClientBuilder;
import com.aliyun.oss.OSSException;
import com.aliyun.oss.model.DeleteObjectsRequest;
import com.aliyun.oss.model.ObjectMetadata;
import java.io.File;
import java.io.InputStream;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AliFilePlugin
implements FilePlugin {
    private static final Logger log = LoggerFactory.getLogger(AliFilePlugin.class);
    private OssSetting ossSetting;

    public AliFilePlugin(OssSetting ossSetting) {
        this.ossSetting = ossSetting;
    }

    @Override
    public OssEnum pluginName() {
        return OssEnum.ALI_OSS;
    }

    private OSS getOssClient() {
        return new OSSClientBuilder().build(this.ossSetting.getAliyunOSSEndPoint(), this.ossSetting.getAliyunOSSAccessKeyId(), this.ossSetting.getAliyunOSSAccessKeySecret());
    }

    private String getUrlPrefix() {
        return "https://" + this.ossSetting.getAliyunOSSBucketName() + "." + this.ossSetting.getAliyunOSSEndPoint() + "/";
    }

    @Override
    public String pathUpload(String filePath, String key) {
        OSS ossClient = this.getOssClient();
        try {
            ossClient.putObject(this.ossSetting.getAliyunOSSBucketName(), key, new File(filePath));
        }
        catch (OSSException oe) {
            log.error("Caught an OSSException, which means your request made it to OSS, but was rejected with an error response for some reason.");
            log.error("Error Message: " + oe.getErrorMessage());
            log.error("Error Code:       " + oe.getErrorCode());
            log.error("Request ID:      " + oe.getRequestId());
            log.error("Host ID:           " + oe.getHostId());
            throw new ServiceException(ResultCode.OSS_EXCEPTION_ERROR);
        }
        catch (ClientException ce) {
            log.error("Caught an ClientException, which means the client encountered a serious internal problem while trying to communicate with OSS, such as not being able to access the network.");
            log.error("Error Message: " + ce.getMessage());
            throw new ServiceException(ResultCode.OSS_EXCEPTION_ERROR);
        }
        finally {
            ossClient.shutdown();
        }
        ossClient.shutdown();
        return this.getUrlPrefix() + key;
    }

    @Override
    public String inputStreamUpload(InputStream inputStream, String key) {
        OSS ossClient = this.getOssClient();
        try {
            ObjectMetadata meta = new ObjectMetadata();
            meta.setContentType("image/jpg");
            ossClient.putObject(this.ossSetting.getAliyunOSSBucketName(), key, inputStream, meta);
        }
        catch (OSSException oe) {
            log.error("Caught an OSSException, which means your request made it to OSS, but was rejected with an error response for some reason.");
            log.error("Error Message: " + oe.getErrorMessage());
            log.error("Error Code:       " + oe.getErrorCode());
            log.error("Request ID:      " + oe.getRequestId());
            log.error("Host ID:           " + oe.getHostId());
            throw new ServiceException(ResultCode.OSS_EXCEPTION_ERROR);
        }
        catch (ClientException ce) {
            log.error("Caught an ClientException, which means the client encountered a serious internal problem while trying to communicate with OSS, such as not being able to access the network.");
            log.error("Error Message: " + ce.getMessage());
            throw new ServiceException(ResultCode.OSS_EXCEPTION_ERROR);
        }
        finally {
            ossClient.shutdown();
        }
        return this.getUrlPrefix() + key;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String uploadAndGetDownloadUrl(InputStream inputStream, String fileName) {
        OSS ossClient = this.getOssClient();
        try {
            ObjectMetadata meta = new ObjectMetadata();
            meta.setContentType("octet-stream");
            ossClient.putObject(this.ossSetting.getAliyunOSSBucketName(), fileName, inputStream, meta);
        }
        catch (Exception e) {
            log.info("uploadAndGetDownloadUrl error", (Throwable)e);
        }
        finally {
            ossClient.shutdown();
        }
        return this.getUrlPrefix() + fileName;
    }

    @Override
    public void deleteFile(List<String> key) {
        OSS ossClient = this.getOssClient();
        try {
            ossClient.deleteObjects(new DeleteObjectsRequest(this.ossSetting.getAliyunOSSBucketName()).withKeys(key));
        }
        catch (OSSException oe) {
            log.error("Caught an OSSException, which means your request made it to OSS, but was rejected with an error response for some reason.");
            log.error("Error Message: " + oe.getErrorMessage());
            log.error("Error Code:       " + oe.getErrorCode());
            log.error("Request ID:      " + oe.getRequestId());
            log.error("Host ID:           " + oe.getHostId());
            throw new ServiceException(ResultCode.OSS_DELETE_ERROR);
        }
        catch (ClientException ce) {
            log.error("Caught an ClientException, which means the client encountered a serious internal problem while trying to communicate with OSS, such as not being able to access the network.");
            log.error("Error Message: " + ce.getMessage());
            throw new ServiceException(ResultCode.OSS_DELETE_ERROR);
        }
        finally {
            ossClient.shutdown();
        }
    }
}

