/*
 * Decompiled with CFR 0.152.
 */
package cn.lili.modules.file.plugin.impl;

import cn.lili.common.enums.ResultCode;
import cn.lili.common.exception.ServiceException;
import cn.lili.modules.file.entity.enums.OssEnum;
import cn.lili.modules.file.plugin.FilePlugin;
import cn.lili.modules.system.entity.dto.OssSetting;
import com.qcloud.cos.COSClient;
import com.qcloud.cos.ClientConfig;
import com.qcloud.cos.auth.BasicCOSCredentials;
import com.qcloud.cos.auth.COSCredentials;
import com.qcloud.cos.exception.CosClientException;
import com.qcloud.cos.exception.CosServiceException;
import com.qcloud.cos.http.HttpProtocol;
import com.qcloud.cos.model.DeleteObjectsRequest;
import com.qcloud.cos.model.ObjectMetadata;
import com.qcloud.cos.region.Region;
import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TencentFilePlugin
implements FilePlugin {
    private static final Logger log = LoggerFactory.getLogger(TencentFilePlugin.class);
    private OssSetting ossSetting;

    public TencentFilePlugin(OssSetting ossSetting) {
        this.ossSetting = ossSetting;
    }

    @Override
    public OssEnum pluginName() {
        return OssEnum.TENCENT_COS;
    }

    private COSClient getCOSClient() {
        BasicCOSCredentials cred = new BasicCOSCredentials(this.ossSetting.getTencentCOSSecretId(), this.ossSetting.getTencentCOSSecretKey());
        ClientConfig clientConfig = new ClientConfig(new Region("COS_REGION"));
        clientConfig.setHttpProtocol(HttpProtocol.https);
        return new COSClient((COSCredentials)cred, clientConfig);
    }

    @Override
    public String uploadAndGetDownloadUrl(InputStream inputStream, String fileName) {
        return null;
    }

    private String getUrlPrefix() {
        return "https://" + this.ossSetting.getTencentCOSBucket() + "." + this.ossSetting.getTencentCOSEndPoint() + "/";
    }

    @Override
    public String pathUpload(String filePath, String key) {
        COSClient cosClient = this.getCOSClient();
        try {
            cosClient.putObject(this.ossSetting.getTencentCOSBucket(), key, new File(filePath));
        }
        catch (CosServiceException oe) {
            throw new ServiceException(ResultCode.OSS_EXCEPTION_ERROR);
        }
        catch (CosClientException ce) {
            throw new ServiceException(ResultCode.OSS_EXCEPTION_ERROR);
        }
        finally {
            cosClient.shutdown();
        }
        return this.getUrlPrefix() + key;
    }

    @Override
    public String inputStreamUpload(InputStream inputStream, String key) {
        COSClient cosClient = this.getCOSClient();
        try {
            ObjectMetadata meta = new ObjectMetadata();
            meta.setContentType("image/jpg");
            cosClient.putObject(this.ossSetting.getTencentCOSBucket(), key, inputStream, meta);
        }
        catch (CosServiceException oe) {
            throw new ServiceException(ResultCode.OSS_EXCEPTION_ERROR);
        }
        catch (CosClientException ce) {
            throw new ServiceException(ResultCode.OSS_EXCEPTION_ERROR);
        }
        finally {
            cosClient.shutdown();
        }
        return this.getUrlPrefix() + key;
    }

    @Override
    public void deleteFile(List<String> keys) {
        COSClient cosClient = this.getCOSClient();
        try {
            ArrayList<DeleteObjectsRequest.KeyVersion> delObjects = new ArrayList<DeleteObjectsRequest.KeyVersion>();
            for (String key : keys) {
                delObjects.add(new DeleteObjectsRequest.KeyVersion(key));
            }
            cosClient.deleteObjects(new DeleteObjectsRequest(this.ossSetting.getTencentCOSBucket()).withKeys(delObjects));
        }
        catch (CosServiceException oe) {
            throw new ServiceException(ResultCode.OSS_EXCEPTION_ERROR);
        }
        catch (CosClientException ce) {
            throw new ServiceException(ResultCode.OSS_EXCEPTION_ERROR);
        }
        finally {
            cosClient.shutdown();
        }
    }
}

