/*
 * Decompiled with CFR 0.152.
 */
package cn.lili.modules.order.cart.entity.vo;

import cn.lili.common.utils.CurrencyUtil;
import cn.lili.modules.distribution.entity.dos.DistributionGoods;
import cn.lili.modules.goods.entity.dos.GoodsSku;
import cn.lili.modules.order.cart.entity.enums.CartTypeEnum;
import cn.lili.modules.order.cart.entity.vo.CartBase;
import cn.lili.modules.promotion.tools.PromotionTools;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Map;

public class CartSkuVO
extends CartBase
implements Serializable {
    private static final long serialVersionUID = -894598033321906974L;
    private String sn;
    private GoodsSku goodsSku;
    private DistributionGoods distributionGoods;
    @ApiModelProperty(value="\u8d2d\u4e70\u6570\u91cf")
    private Integer num;
    @ApiModelProperty(value="\u8d2d\u4e70\u65f6\u7684\u6210\u4ea4\u4ef7")
    private Double purchasePrice;
    @ApiModelProperty(value="\u5c0f\u8bb0")
    private Double subTotal;
    @ApiModelProperty(value="\u5c0f\u8bb0")
    private Double utilPrice;
    @ApiModelProperty(value="\u662f\u5426\u9009\u4e2d\uff0c\u8981\u53bb\u7ed3\u7b97")
    private Boolean checked;
    @ApiModelProperty(value="\u662f\u5426\u514d\u8fd0\u8d39")
    private Boolean isFreeFreight;
    @ApiModelProperty(value="\u662f\u5426\u5931\u6548 ")
    private Boolean invalid;
    @ApiModelProperty(value="\u8d2d\u7269\u8f66\u5546\u54c1\u9519\u8bef\u6d88\u606f")
    private String errorMessage;
    @ApiModelProperty(value="\u662f\u5426\u53ef\u914d\u9001")
    private Boolean isShip;
    @ApiModelProperty(value="\u62fc\u56e2id \u5982\u679c\u662f\u62fc\u56e2\u8d2d\u4e70 \u6b64\u503c\u4e3a\u62fc\u56e2\u6d3b\u52a8id\uff0c\u5f53pintuanId\u4e3a\u7a7a\uff0c\u5219\u8868\u793a\u666e\u901a\u8d2d\u4e70\uff08\u6216\u8005\u62fc\u56e2\u5546\u54c1\uff0c\u5355\u72ec\u8d2d\u4e70\uff09")
    private String pintuanId;
    @ApiModelProperty(value="\u780d\u4ef7ID")
    private String kanjiaId;
    @ApiModelProperty(value="\u79ef\u5206\u5151\u6362ID")
    private String pointsId;
    @ApiModelProperty(value="\u79ef\u5206\u8d2d\u4e70 \u79ef\u5206\u6570\u91cf")
    private Long points;
    @ApiModelProperty(value="\u5546\u54c1\u4fc3\u9500\u6d3b\u52a8\u96c6\u5408\uff0ckey \u4e3a \u4fc3\u9500\u6d3b\u52a8\u7c7b\u578b\uff0cvalue \u4e3a \u4fc3\u9500\u6d3b\u52a8\u5b9e\u4f53\u4fe1\u606f ")
    private Map<String, Object> promotionMap;
    @ApiModelProperty(value="\u8d2d\u7269\u8f66\u7c7b\u578b")
    private CartTypeEnum cartType;
    @ApiModelProperty(value="\u914d\u9001\u65b9\u5f0f")
    private String deliveryMethod;

    public CartSkuVO(GoodsSku goodsSku) {
        this.goodsSku = goodsSku;
        if (goodsSku.getUpdateTime() == null) {
            this.goodsSku.setUpdateTime(goodsSku.getCreateTime());
        }
        this.checked = true;
        this.invalid = false;
        this.errorMessage = "";
        this.isShip = true;
        this.purchasePrice = goodsSku.getPromotionFlag() != null && goodsSku.getPromotionFlag() != false ? goodsSku.getPromotionPrice() : goodsSku.getPrice();
        this.isFreeFreight = false;
        this.utilPrice = goodsSku.getPromotionFlag() != null && goodsSku.getPromotionFlag() != false ? goodsSku.getPromotionPrice() : goodsSku.getPrice();
        this.setStoreId(goodsSku.getStoreId());
        this.setStoreName(goodsSku.getStoreName());
    }

    public CartSkuVO(GoodsSku goodsSku, Map<String, Object> promotionMap) {
        this(goodsSku);
        if (promotionMap != null && !promotionMap.isEmpty()) {
            this.promotionMap = promotionMap;
        }
    }

    public void rebuildBySku(GoodsSku goodsSku) {
        this.goodsSku = goodsSku;
        this.purchasePrice = goodsSku.getPromotionFlag() != null && goodsSku.getPromotionFlag() != false ? goodsSku.getPromotionPrice() : goodsSku.getPrice();
        this.utilPrice = goodsSku.getPromotionFlag() != null && goodsSku.getPromotionFlag() != false ? goodsSku.getPromotionPrice() : goodsSku.getPrice();
        this.subTotal = CurrencyUtil.mul((double)this.getPurchasePrice(), (double)this.getNum().intValue());
        this.setStoreId(goodsSku.getStoreId());
        this.setStoreName(goodsSku.getStoreName());
    }

    public Map<String, Object> getPromotionMap() {
        return PromotionTools.filterInvalidPromotionsMap(this.promotionMap);
    }

    public Map<String, Object> notFilterPromotionMap() {
        return this.promotionMap;
    }

    public String getSn() {
        return this.sn;
    }

    public GoodsSku getGoodsSku() {
        return this.goodsSku;
    }

    public DistributionGoods getDistributionGoods() {
        return this.distributionGoods;
    }

    public Integer getNum() {
        return this.num;
    }

    public Double getPurchasePrice() {
        return this.purchasePrice;
    }

    public Double getSubTotal() {
        return this.subTotal;
    }

    public Double getUtilPrice() {
        return this.utilPrice;
    }

    public Boolean getChecked() {
        return this.checked;
    }

    public Boolean getIsFreeFreight() {
        return this.isFreeFreight;
    }

    public Boolean getInvalid() {
        return this.invalid;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public Boolean getIsShip() {
        return this.isShip;
    }

    public String getPintuanId() {
        return this.pintuanId;
    }

    public String getKanjiaId() {
        return this.kanjiaId;
    }

    public String getPointsId() {
        return this.pointsId;
    }

    public Long getPoints() {
        return this.points;
    }

    public CartTypeEnum getCartType() {
        return this.cartType;
    }

    public String getDeliveryMethod() {
        return this.deliveryMethod;
    }

    public void setSn(String sn) {
        this.sn = sn;
    }

    public void setGoodsSku(GoodsSku goodsSku) {
        this.goodsSku = goodsSku;
    }

    public void setDistributionGoods(DistributionGoods distributionGoods) {
        this.distributionGoods = distributionGoods;
    }

    public void setNum(Integer num) {
        this.num = num;
    }

    public void setPurchasePrice(Double purchasePrice) {
        this.purchasePrice = purchasePrice;
    }

    public void setSubTotal(Double subTotal) {
        this.subTotal = subTotal;
    }

    public void setUtilPrice(Double utilPrice) {
        this.utilPrice = utilPrice;
    }

    public void setChecked(Boolean checked) {
        this.checked = checked;
    }

    public void setIsFreeFreight(Boolean isFreeFreight) {
        this.isFreeFreight = isFreeFreight;
    }

    public void setInvalid(Boolean invalid) {
        this.invalid = invalid;
    }

    public void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
    }

    public void setIsShip(Boolean isShip) {
        this.isShip = isShip;
    }

    public void setPintuanId(String pintuanId) {
        this.pintuanId = pintuanId;
    }

    public void setKanjiaId(String kanjiaId) {
        this.kanjiaId = kanjiaId;
    }

    public void setPointsId(String pointsId) {
        this.pointsId = pointsId;
    }

    public void setPoints(Long points) {
        this.points = points;
    }

    public void setPromotionMap(Map<String, Object> promotionMap) {
        this.promotionMap = promotionMap;
    }

    public void setCartType(CartTypeEnum cartType) {
        this.cartType = cartType;
    }

    public void setDeliveryMethod(String deliveryMethod) {
        this.deliveryMethod = deliveryMethod;
    }

    @Override
    public String toString() {
        return "CartSkuVO(sn=" + this.getSn() + ", goodsSku=" + (Object)((Object)this.getGoodsSku()) + ", distributionGoods=" + (Object)((Object)this.getDistributionGoods()) + ", num=" + this.getNum() + ", purchasePrice=" + this.getPurchasePrice() + ", subTotal=" + this.getSubTotal() + ", utilPrice=" + this.getUtilPrice() + ", checked=" + this.getChecked() + ", isFreeFreight=" + this.getIsFreeFreight() + ", invalid=" + this.getInvalid() + ", errorMessage=" + this.getErrorMessage() + ", isShip=" + this.getIsShip() + ", pintuanId=" + this.getPintuanId() + ", kanjiaId=" + this.getKanjiaId() + ", pointsId=" + this.getPointsId() + ", points=" + this.getPoints() + ", promotionMap=" + this.getPromotionMap() + ", cartType=" + (Object)((Object)this.getCartType()) + ", deliveryMethod=" + this.getDeliveryMethod() + ")";
    }

    public CartSkuVO() {
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CartSkuVO)) {
            return false;
        }
        CartSkuVO other = (CartSkuVO)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Integer this$num = this.getNum();
        Integer other$num = other.getNum();
        if (this$num == null ? other$num != null : !((Object)this$num).equals(other$num)) {
            return false;
        }
        Double this$purchasePrice = this.getPurchasePrice();
        Double other$purchasePrice = other.getPurchasePrice();
        if (this$purchasePrice == null ? other$purchasePrice != null : !((Object)this$purchasePrice).equals(other$purchasePrice)) {
            return false;
        }
        Double this$subTotal = this.getSubTotal();
        Double other$subTotal = other.getSubTotal();
        if (this$subTotal == null ? other$subTotal != null : !((Object)this$subTotal).equals(other$subTotal)) {
            return false;
        }
        Double this$utilPrice = this.getUtilPrice();
        Double other$utilPrice = other.getUtilPrice();
        if (this$utilPrice == null ? other$utilPrice != null : !((Object)this$utilPrice).equals(other$utilPrice)) {
            return false;
        }
        Boolean this$checked = this.getChecked();
        Boolean other$checked = other.getChecked();
        if (this$checked == null ? other$checked != null : !((Object)this$checked).equals(other$checked)) {
            return false;
        }
        Boolean this$isFreeFreight = this.getIsFreeFreight();
        Boolean other$isFreeFreight = other.getIsFreeFreight();
        if (this$isFreeFreight == null ? other$isFreeFreight != null : !((Object)this$isFreeFreight).equals(other$isFreeFreight)) {
            return false;
        }
        Boolean this$invalid = this.getInvalid();
        Boolean other$invalid = other.getInvalid();
        if (this$invalid == null ? other$invalid != null : !((Object)this$invalid).equals(other$invalid)) {
            return false;
        }
        Boolean this$isShip = this.getIsShip();
        Boolean other$isShip = other.getIsShip();
        if (this$isShip == null ? other$isShip != null : !((Object)this$isShip).equals(other$isShip)) {
            return false;
        }
        Long this$points = this.getPoints();
        Long other$points = other.getPoints();
        if (this$points == null ? other$points != null : !((Object)this$points).equals(other$points)) {
            return false;
        }
        String this$sn = this.getSn();
        String other$sn = other.getSn();
        if (this$sn == null ? other$sn != null : !this$sn.equals(other$sn)) {
            return false;
        }
        GoodsSku this$goodsSku = this.getGoodsSku();
        GoodsSku other$goodsSku = other.getGoodsSku();
        if (this$goodsSku == null ? other$goodsSku != null : !((Object)((Object)this$goodsSku)).equals((Object)other$goodsSku)) {
            return false;
        }
        DistributionGoods this$distributionGoods = this.getDistributionGoods();
        DistributionGoods other$distributionGoods = other.getDistributionGoods();
        if (this$distributionGoods == null ? other$distributionGoods != null : !((Object)((Object)this$distributionGoods)).equals((Object)other$distributionGoods)) {
            return false;
        }
        String this$errorMessage = this.getErrorMessage();
        String other$errorMessage = other.getErrorMessage();
        if (this$errorMessage == null ? other$errorMessage != null : !this$errorMessage.equals(other$errorMessage)) {
            return false;
        }
        String this$pintuanId = this.getPintuanId();
        String other$pintuanId = other.getPintuanId();
        if (this$pintuanId == null ? other$pintuanId != null : !this$pintuanId.equals(other$pintuanId)) {
            return false;
        }
        String this$kanjiaId = this.getKanjiaId();
        String other$kanjiaId = other.getKanjiaId();
        if (this$kanjiaId == null ? other$kanjiaId != null : !this$kanjiaId.equals(other$kanjiaId)) {
            return false;
        }
        String this$pointsId = this.getPointsId();
        String other$pointsId = other.getPointsId();
        if (this$pointsId == null ? other$pointsId != null : !this$pointsId.equals(other$pointsId)) {
            return false;
        }
        Map<String, Object> this$promotionMap = this.getPromotionMap();
        Map<String, Object> other$promotionMap = other.getPromotionMap();
        if (this$promotionMap == null ? other$promotionMap != null : !((Object)this$promotionMap).equals(other$promotionMap)) {
            return false;
        }
        CartTypeEnum this$cartType = this.getCartType();
        CartTypeEnum other$cartType = other.getCartType();
        if (this$cartType == null ? other$cartType != null : !((Object)((Object)this$cartType)).equals((Object)other$cartType)) {
            return false;
        }
        String this$deliveryMethod = this.getDeliveryMethod();
        String other$deliveryMethod = other.getDeliveryMethod();
        return !(this$deliveryMethod == null ? other$deliveryMethod != null : !this$deliveryMethod.equals(other$deliveryMethod));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof CartSkuVO;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Integer $num = this.getNum();
        result = result * 59 + ($num == null ? 43 : ((Object)$num).hashCode());
        Double $purchasePrice = this.getPurchasePrice();
        result = result * 59 + ($purchasePrice == null ? 43 : ((Object)$purchasePrice).hashCode());
        Double $subTotal = this.getSubTotal();
        result = result * 59 + ($subTotal == null ? 43 : ((Object)$subTotal).hashCode());
        Double $utilPrice = this.getUtilPrice();
        result = result * 59 + ($utilPrice == null ? 43 : ((Object)$utilPrice).hashCode());
        Boolean $checked = this.getChecked();
        result = result * 59 + ($checked == null ? 43 : ((Object)$checked).hashCode());
        Boolean $isFreeFreight = this.getIsFreeFreight();
        result = result * 59 + ($isFreeFreight == null ? 43 : ((Object)$isFreeFreight).hashCode());
        Boolean $invalid = this.getInvalid();
        result = result * 59 + ($invalid == null ? 43 : ((Object)$invalid).hashCode());
        Boolean $isShip = this.getIsShip();
        result = result * 59 + ($isShip == null ? 43 : ((Object)$isShip).hashCode());
        Long $points = this.getPoints();
        result = result * 59 + ($points == null ? 43 : ((Object)$points).hashCode());
        String $sn = this.getSn();
        result = result * 59 + ($sn == null ? 43 : $sn.hashCode());
        GoodsSku $goodsSku = this.getGoodsSku();
        result = result * 59 + ($goodsSku == null ? 43 : ((Object)((Object)$goodsSku)).hashCode());
        DistributionGoods $distributionGoods = this.getDistributionGoods();
        result = result * 59 + ($distributionGoods == null ? 43 : ((Object)((Object)$distributionGoods)).hashCode());
        String $errorMessage = this.getErrorMessage();
        result = result * 59 + ($errorMessage == null ? 43 : $errorMessage.hashCode());
        String $pintuanId = this.getPintuanId();
        result = result * 59 + ($pintuanId == null ? 43 : $pintuanId.hashCode());
        String $kanjiaId = this.getKanjiaId();
        result = result * 59 + ($kanjiaId == null ? 43 : $kanjiaId.hashCode());
        String $pointsId = this.getPointsId();
        result = result * 59 + ($pointsId == null ? 43 : $pointsId.hashCode());
        Map<String, Object> $promotionMap = this.getPromotionMap();
        result = result * 59 + ($promotionMap == null ? 43 : ((Object)$promotionMap).hashCode());
        CartTypeEnum $cartType = this.getCartType();
        result = result * 59 + ($cartType == null ? 43 : ((Object)((Object)$cartType)).hashCode());
        String $deliveryMethod = this.getDeliveryMethod();
        result = result * 59 + ($deliveryMethod == null ? 43 : $deliveryMethod.hashCode());
        return result;
    }
}

