/*
 * Decompiled with CFR 0.152.
 */
package cn.lili.modules.order.order.client;

import cn.lili.modules.order.fallback.OrderFallback;
import cn.lili.modules.order.order.entity.dos.Order;
import cn.lili.modules.order.order.entity.dto.OrderSearchParams;
import cn.lili.modules.order.order.entity.dto.PaymentLogSearchParams;
import cn.lili.modules.order.order.entity.vo.OrderDetailVO;
import cn.lili.modules.order.order.entity.vo.PaymentLog;
import cn.lili.modules.store.entity.dos.Store;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

@FeignClient(name="order-service", contextId="order", fallback=OrderFallback.class)
public interface OrderClient {
    @GetMapping(value={"/feign/order/query/{sn}"})
    public Order getBySn(@PathVariable String var1);

    @GetMapping(value={"/feign/order/pay"})
    public void payOrder(@RequestParam(value="sn") String var1, @RequestParam(value="payment_method") String var2, @RequestParam(value="receivable_no") String var3, @RequestParam(value="pay_order_no") String var4);

    @GetMapping(value={"/feign/order/system/cancel"})
    public void systemCancel(@RequestParam String var1, @RequestParam String var2);

    @GetMapping(value={"/feign/order/query/{orderSn}/payment-total"})
    public Double getPaymentTotal(@PathVariable String var1);

    @GetMapping(value={"/feign/order/query/{sn}/detail-vo"})
    public OrderDetailVO queryDetail(@PathVariable String var1);

    @GetMapping(value={"/feign/order/query/{sn}/by-trade-sn"})
    public List<Order> getByTradeSn(@PathVariable String var1);

    @PostMapping(value={"/feign/order/query/list"})
    public List<Order> queryListByParams(@RequestBody OrderSearchParams var1);

    @GetMapping(value={"/feign/order/query/promotions/list"})
    public List<Order> queryListByPromotion(@RequestParam String var1, @RequestParam String var2, @RequestParam String var3, @RequestParam String var4);

    @GetMapping(value={"/feign/order/query/promotions/count"})
    public long queryCountByPromotion(@RequestParam String var1, @RequestParam String var2, @RequestParam String var3, @RequestParam String var4);

    @GetMapping(value={"/feign/order/fictitious/pintuan/{pintuanId}"})
    public boolean checkFictitiousOrder(@PathVariable String var1, @RequestParam Integer var2, @RequestParam Boolean var3);

    @PostMapping(value={"/feign/order/fictitious/save"})
    public void save(@RequestBody Order var1);

    @GetMapping(value={"/feign/order/{orderSn}/fictitious/afterOrderConfirm"})
    public void afterOrderConfirm(@PathVariable String var1);

    @GetMapping(value={"/feign/order/{orderSn}/system/complete"})
    public void systemComplete(@PathVariable String var1);

    @GetMapping(value={"/feign/order/agglomerate/pintuan/{pintuanId}"})
    public void agglomeratePintuanOrder(@PathVariable String var1, @RequestParam String var2);

    @PutMapping(value={"/feign/order/fictitious/update"})
    public void update(@RequestBody Order var1);

    @PostMapping(value={"/feign/order/fictitious/getOne"})
    public Order getOne(@RequestBody Order var1);

    @PostMapping(value={"/feign/order/getOrderListByTrade"})
    public List<Order> getOrderListByTrade(@RequestParam String var1);

    @PostMapping(value={"/feign/order/queryPaymentLogs"})
    public Page<PaymentLog> queryPaymentLogs(@RequestBody PaymentLogSearchParams var1);

    @PostMapping(value={"/feign/order/queryPaymentLogsList"})
    public List<PaymentLog> queryPaymentLogsList(@RequestBody PaymentLogSearchParams var1);

    @PutMapping(value={"/feign/order/queryPaymentLogsList"})
    public void editPaymentLogsList(@RequestBody List<PaymentLog> var1);

    @PutMapping(value={"/feign/order/updateStoreName"})
    public void updateStoreName(@RequestBody Store var1);

    @PostMapping(value={"/feign/order/afterSaleCallBack"})
    public void afterSaleCallBack(@RequestParam Boolean var1, @RequestParam String var2);

    @PutMapping(value={"/feign/order/updateMchInfo"})
    public void updateMchInfo(@RequestBody Order var1);

    @PostMapping(value={"/feign/order/update"})
    public Boolean updateSelective(@RequestBody Order var1);
}

