/*
 * Decompiled with CFR 0.152.
 */
package cn.lili.modules.order.order.entity.dto;

import cn.hutool.core.text.CharSequenceUtil;
import cn.hutool.core.util.StrUtil;
import cn.lili.common.security.AuthUser;
import cn.lili.common.security.context.UserContext;
import cn.lili.common.security.enums.UserEnums;
import cn.lili.common.utils.DateUtil;
import cn.lili.common.vo.PageVO;
import cn.lili.modules.order.order.entity.enums.OrderStatusEnum;
import cn.lili.modules.order.order.entity.enums.OrderTagEnum;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModelProperty;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.MapUtils;
import org.springframework.format.annotation.DateTimeFormat;

public class OrderSearchParams
extends PageVO {
    private static final long serialVersionUID = -6380573339089959194L;
    @ApiModelProperty(value="\u5546\u54c1\u540d\u79f0")
    private String goodsName;
    @ApiModelProperty(value="\u8ba2\u5355\u7f16\u53f7")
    private String orderSn;
    @ApiModelProperty(value="\u9875\u9762\u6807\u7b7e", example="ALL:\u5168\u90e8,WAIT_PAY:\u5f85\u4ed8\u6b3e,WAIT_ROG:\u5f85\u6536\u8d27,CANCELLED:\u5df2\u53d6\u6d88,COMPLETE:\u5df2\u5b8c\u6210")
    private String tag;
    @ApiModelProperty(value="\u5546\u5bb6ID")
    private String storeId;
    @ApiModelProperty(value="\u4f1a\u5458ID")
    private String memberId;
    @ApiModelProperty(value="\u6536\u8d27\u4eba")
    private String shipName;
    @ApiModelProperty(value="\u4e70\u5bb6\u6635\u79f0")
    private String buyerName;
    @ApiModelProperty(value="\u8ba2\u5355\u72b6\u6001")
    private String orderStatus;
    @ApiModelProperty(value="\u4ed8\u6b3e\u72b6\u6001")
    private String payStatus;
    @ApiModelProperty(value="\u5173\u952e\u5b57 \u5546\u54c1\u540d\u79f0/\u4e70\u5bb6\u540d\u79f0/\u5e97\u94fa\u540d\u79f0")
    private String keywords;
    @ApiModelProperty(value="\u4ed8\u6b3e\u65b9\u5f0f")
    private String paymentType;
    @ApiModelProperty(value="\u8ba2\u5355\u7c7b\u578b", allowableValues="NORMAL,VIRTUAL,GIFT,PINTUAN,POINT")
    private String orderType;
    @ApiModelProperty(value="\u652f\u4ed8\u65b9\u5f0f")
    private String paymentMethod;
    @JsonFormat(timezone="GMT+8", pattern="yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    @ApiModelProperty(value="\u652f\u4ed8\u65f6\u95f4")
    private Date paymentTime;
    @JsonFormat(timezone="GMT+8", pattern="yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern="yyyy-MM-dd")
    @ApiModelProperty(value="\u4e0b\u5355\u5f00\u59cb\u65f6\u95f4")
    private Date startDate;
    @JsonFormat(timezone="GMT+8", pattern="yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern="yyyy-MM-dd")
    @ApiModelProperty(value="\u5c0f\u4e8e\u7b49\u4e8e\u7684\u5f00\u59cb\u65f6\u95f4")
    private Date leCreateTime;
    @JsonFormat(timezone="GMT+8", pattern="yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern="yyyy-MM-dd")
    @ApiModelProperty(value="\u5c0f\u4e8e\u7b49\u4e8e\u7684\u8ba2\u5355\u53d1\u8d27\u65f6\u95f4")
    private Date leLogisticsTime;
    @JsonFormat(timezone="GMT+8", pattern="yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern="yyyy-MM-dd")
    @ApiModelProperty(value="\u5c0f\u4e8e\u7b49\u4e8e\u7684\u5b8c\u6210\u65f6\u95f4")
    private Date leCompleteTime;
    @JsonFormat(timezone="GMT+8", pattern="yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern="yyyy-MM-dd")
    @ApiModelProperty(value="\u4e0b\u5355\u7ed3\u675f\u65f6\u95f4")
    private Date endDate;
    @ApiModelProperty(value="\u8ba2\u5355\u6765\u6e90")
    private String clientType;
    @ApiModelProperty(value="\u8bc4\u8bba\u72b6\u6001:\u672a\u8bc4\u8bba(UNFINISHED),\u5f85\u8ffd\u8bc4(WAIT_CHASE),\u8bc4\u8bba\u5b8c\u6210(FINISHED)\uff0c")
    private String commentStatus;
    @ApiModelProperty(value="\u662f\u5426\u4e3a\u5176\u4ed6\u8ba2\u5355\u4e0b\u7684\u8ba2\u5355\uff0c\u5982\u679c\u662f\u5219\u4e3a\u4f9d\u8d56\u8ba2\u5355\u7684sn\uff0c\u5426\u5219\u4e3a\u7a7a")
    private String parentOrderSn;
    @ApiModelProperty(value="\u662f\u5426\u4e3a\u67d0\u8ba2\u5355\u7c7b\u578b\u7684\u8ba2\u5355\uff0c\u5982\u679c\u662f\u5219\u4e3a\u8ba2\u5355\u7c7b\u578b\u7684id\uff0c\u5426\u5219\u4e3a\u7a7a")
    private String promotionId;
    @ApiModelProperty(value="\u552e\u540e\u72b6\u6001")
    private String afterSaleStatus;
    @ApiModelProperty(value="\u6295\u8bc9\u72b6\u6001")
    private String complainStatus;
    @ApiModelProperty(value="\u8ba2\u5355\u4fc3\u9500\u7c7b\u578b")
    private String orderPromotionType;
    @ApiModelProperty(value="\u603b\u4ef7\u683c,\u53ef\u4ee5\u4e3a\u8303\u56f4\uff0c\u598210_1000")
    private String flowPrice;
    @ApiModelProperty(value="\u6536\u4ef6\u4eba\u624b\u673a")
    private String consigneeMobile;
    @ApiModelProperty(value="sql in\u6761\u4ef6\u5b57\u6bb5")
    private Map<String, List<String>> inColumnValueMap;

    public <T> QueryWrapper<T> queryWrapper() {
        AuthUser currentUser = UserContext.getCurrentUser();
        QueryWrapper wrapper = new QueryWrapper();
        if (CharSequenceUtil.isNotEmpty((CharSequence)this.keywords)) {
            wrapper.like((Object)"o.sn", (Object)this.keywords);
        }
        if (currentUser != null) {
            if (currentUser.getRole() != null && CharSequenceUtil.equals((CharSequence)currentUser.getRole().name(), (CharSequence)UserEnums.STORE.name())) {
                wrapper.eq((Object)"o.store_id", (Object)currentUser.getStoreId());
            }
            if (currentUser.getRole() != null && CharSequenceUtil.equals((CharSequence)currentUser.getRole().name(), (CharSequence)UserEnums.MANAGER.name())) {
                wrapper.eq(CharSequenceUtil.equals((CharSequence)currentUser.getRole().name(), (CharSequence)UserEnums.MANAGER.name()) && CharSequenceUtil.isNotEmpty((CharSequence)this.storeId), (Object)"o.store_id", (Object)this.storeId);
            }
            if (currentUser.getRole() != null && CharSequenceUtil.equals((CharSequence)currentUser.getRole().name(), (CharSequence)UserEnums.MEMBER.name())) {
                wrapper.eq(CharSequenceUtil.equals((CharSequence)currentUser.getRole().name(), (CharSequence)UserEnums.MEMBER.name()) && this.memberId == null, (Object)"o.member_id", (Object)currentUser.getId());
            }
        }
        wrapper.eq(CharSequenceUtil.isNotEmpty((CharSequence)this.memberId), (Object)"o.member_id", (Object)this.memberId);
        wrapper.like(CharSequenceUtil.isNotEmpty((CharSequence)this.consigneeMobile), (Object)"o.consignee_mobile", (Object)this.consigneeMobile);
        wrapper.like(CharSequenceUtil.isNotEmpty((CharSequence)this.orderSn), (Object)"o.sn", (Object)this.orderSn);
        wrapper.ge(this.startDate != null, (Object)"o.create_time", (Object)this.startDate);
        wrapper.le(this.endDate != null, (Object)"o.create_time", (Object)DateUtil.endOfDate((Date)this.endDate));
        wrapper.le(this.leCreateTime != null, (Object)"o.create_time", (Object)this.leCreateTime);
        wrapper.le(this.leLogisticsTime != null, (Object)"o.logistics_time", (Object)this.leLogisticsTime);
        wrapper.le(this.leCompleteTime != null, (Object)"o.complete_time", (Object)this.leCompleteTime);
        wrapper.like(CharSequenceUtil.isNotEmpty((CharSequence)this.buyerName), (Object)"o.member_name", (Object)this.buyerName);
        wrapper.eq(CharSequenceUtil.isNotEmpty((CharSequence)this.orderType), (Object)"o.order_type", (Object)this.orderType);
        wrapper.like(CharSequenceUtil.isNotEmpty((CharSequence)this.shipName), (Object)"o.consignee_name", (Object)this.shipName);
        wrapper.like(CharSequenceUtil.isNotEmpty((CharSequence)this.goodsName), (Object)"oi.goods_name", (Object)this.goodsName);
        wrapper.like(CharSequenceUtil.isNotEmpty((CharSequence)this.paymentType), (Object)"o.payment_type", (Object)this.paymentType);
        wrapper.eq(CharSequenceUtil.isNotEmpty((CharSequence)this.paymentMethod), (Object)"o.payment_method", (Object)this.paymentMethod);
        wrapper.eq(CharSequenceUtil.isNotEmpty((CharSequence)this.orderStatus), (Object)"o.order_status", (Object)this.orderStatus);
        wrapper.eq(CharSequenceUtil.isNotEmpty((CharSequence)this.payStatus), (Object)"o.pay_status", (Object)this.payStatus);
        wrapper.eq(CharSequenceUtil.isNotEmpty((CharSequence)this.afterSaleStatus), (Object)"oi.after_sale_status", (Object)this.afterSaleStatus);
        wrapper.eq(CharSequenceUtil.isNotEmpty((CharSequence)this.complainStatus), (Object)"oi.complain_status", (Object)this.complainStatus);
        wrapper.like(CharSequenceUtil.isNotEmpty((CharSequence)this.clientType), (Object)"o.client_type", (Object)this.clientType);
        wrapper.eq(CharSequenceUtil.isNotEmpty((CharSequence)this.commentStatus), (Object)"oi.comment_status", (Object)this.commentStatus);
        if (CharSequenceUtil.isNotEmpty((CharSequence)this.tag)) {
            String orderStatusColumn = "o.order_status";
            OrderTagEnum tagEnum = OrderTagEnum.valueOf(this.tag);
            switch (tagEnum) {
                case WAIT_PAY: {
                    wrapper.eq((Object)orderStatusColumn, (Object)OrderStatusEnum.UNPAID.name());
                    break;
                }
                case WAIT_SHIP: {
                    wrapper.eq((Object)orderStatusColumn, (Object)OrderStatusEnum.UNDELIVERED.name());
                    break;
                }
                case WAIT_ROG: {
                    wrapper.eq((Object)orderStatusColumn, (Object)OrderStatusEnum.DELIVERED.name());
                    break;
                }
                case CANCELLED: {
                    wrapper.eq((Object)orderStatusColumn, (Object)OrderStatusEnum.CANCELLED.name());
                    break;
                }
                case COMPLETE: {
                    wrapper.eq((Object)orderStatusColumn, (Object)OrderStatusEnum.COMPLETED.name());
                    break;
                }
            }
        }
        wrapper.eq(this.parentOrderSn != null, (Object)"o.parent_order_sn", (Object)this.parentOrderSn);
        wrapper.eq(CharSequenceUtil.isNotEmpty((CharSequence)this.promotionId), (Object)"o.promotion_id", (Object)this.promotionId);
        wrapper.eq(CharSequenceUtil.isNotEmpty((CharSequence)this.orderPromotionType), (Object)"o.order_promotion_type", (Object)this.orderPromotionType);
        if (CharSequenceUtil.isNotEmpty((CharSequence)this.flowPrice)) {
            String[] s = this.flowPrice.split("_");
            if (s.length > 1) {
                wrapper.between((Object)"o.flow_price", (Object)s[0], (Object)s[1]);
            } else {
                wrapper.ge((Object)"o.flow_price", (Object)s[0]);
            }
        }
        wrapper.eq((Object)"o.delete_flag", (Object)false);
        if (MapUtils.isNotEmpty(this.inColumnValueMap)) {
            for (Map.Entry<String, List<String>> column : this.inColumnValueMap.entrySet()) {
                String inColumn = column.getKey();
                List<String> inColumnValue = column.getValue();
                if (!StrUtil.isNotBlank((CharSequence)inColumn) || inColumnValue == null || inColumnValue.size() <= 0) continue;
                wrapper.in((Object)inColumn, inColumnValue);
            }
        }
        return wrapper;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof OrderSearchParams)) {
            return false;
        }
        OrderSearchParams other = (OrderSearchParams)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$goodsName = this.getGoodsName();
        String other$goodsName = other.getGoodsName();
        if (this$goodsName == null ? other$goodsName != null : !this$goodsName.equals(other$goodsName)) {
            return false;
        }
        String this$orderSn = this.getOrderSn();
        String other$orderSn = other.getOrderSn();
        if (this$orderSn == null ? other$orderSn != null : !this$orderSn.equals(other$orderSn)) {
            return false;
        }
        String this$tag = this.getTag();
        String other$tag = other.getTag();
        if (this$tag == null ? other$tag != null : !this$tag.equals(other$tag)) {
            return false;
        }
        String this$storeId = this.getStoreId();
        String other$storeId = other.getStoreId();
        if (this$storeId == null ? other$storeId != null : !this$storeId.equals(other$storeId)) {
            return false;
        }
        String this$memberId = this.getMemberId();
        String other$memberId = other.getMemberId();
        if (this$memberId == null ? other$memberId != null : !this$memberId.equals(other$memberId)) {
            return false;
        }
        String this$shipName = this.getShipName();
        String other$shipName = other.getShipName();
        if (this$shipName == null ? other$shipName != null : !this$shipName.equals(other$shipName)) {
            return false;
        }
        String this$buyerName = this.getBuyerName();
        String other$buyerName = other.getBuyerName();
        if (this$buyerName == null ? other$buyerName != null : !this$buyerName.equals(other$buyerName)) {
            return false;
        }
        String this$orderStatus = this.getOrderStatus();
        String other$orderStatus = other.getOrderStatus();
        if (this$orderStatus == null ? other$orderStatus != null : !this$orderStatus.equals(other$orderStatus)) {
            return false;
        }
        String this$payStatus = this.getPayStatus();
        String other$payStatus = other.getPayStatus();
        if (this$payStatus == null ? other$payStatus != null : !this$payStatus.equals(other$payStatus)) {
            return false;
        }
        String this$keywords = this.getKeywords();
        String other$keywords = other.getKeywords();
        if (this$keywords == null ? other$keywords != null : !this$keywords.equals(other$keywords)) {
            return false;
        }
        String this$paymentType = this.getPaymentType();
        String other$paymentType = other.getPaymentType();
        if (this$paymentType == null ? other$paymentType != null : !this$paymentType.equals(other$paymentType)) {
            return false;
        }
        String this$orderType = this.getOrderType();
        String other$orderType = other.getOrderType();
        if (this$orderType == null ? other$orderType != null : !this$orderType.equals(other$orderType)) {
            return false;
        }
        String this$paymentMethod = this.getPaymentMethod();
        String other$paymentMethod = other.getPaymentMethod();
        if (this$paymentMethod == null ? other$paymentMethod != null : !this$paymentMethod.equals(other$paymentMethod)) {
            return false;
        }
        Date this$paymentTime = this.getPaymentTime();
        Date other$paymentTime = other.getPaymentTime();
        if (this$paymentTime == null ? other$paymentTime != null : !((Object)this$paymentTime).equals(other$paymentTime)) {
            return false;
        }
        Date this$startDate = this.getStartDate();
        Date other$startDate = other.getStartDate();
        if (this$startDate == null ? other$startDate != null : !((Object)this$startDate).equals(other$startDate)) {
            return false;
        }
        Date this$leCreateTime = this.getLeCreateTime();
        Date other$leCreateTime = other.getLeCreateTime();
        if (this$leCreateTime == null ? other$leCreateTime != null : !((Object)this$leCreateTime).equals(other$leCreateTime)) {
            return false;
        }
        Date this$leLogisticsTime = this.getLeLogisticsTime();
        Date other$leLogisticsTime = other.getLeLogisticsTime();
        if (this$leLogisticsTime == null ? other$leLogisticsTime != null : !((Object)this$leLogisticsTime).equals(other$leLogisticsTime)) {
            return false;
        }
        Date this$leCompleteTime = this.getLeCompleteTime();
        Date other$leCompleteTime = other.getLeCompleteTime();
        if (this$leCompleteTime == null ? other$leCompleteTime != null : !((Object)this$leCompleteTime).equals(other$leCompleteTime)) {
            return false;
        }
        Date this$endDate = this.getEndDate();
        Date other$endDate = other.getEndDate();
        if (this$endDate == null ? other$endDate != null : !((Object)this$endDate).equals(other$endDate)) {
            return false;
        }
        String this$clientType = this.getClientType();
        String other$clientType = other.getClientType();
        if (this$clientType == null ? other$clientType != null : !this$clientType.equals(other$clientType)) {
            return false;
        }
        String this$commentStatus = this.getCommentStatus();
        String other$commentStatus = other.getCommentStatus();
        if (this$commentStatus == null ? other$commentStatus != null : !this$commentStatus.equals(other$commentStatus)) {
            return false;
        }
        String this$parentOrderSn = this.getParentOrderSn();
        String other$parentOrderSn = other.getParentOrderSn();
        if (this$parentOrderSn == null ? other$parentOrderSn != null : !this$parentOrderSn.equals(other$parentOrderSn)) {
            return false;
        }
        String this$promotionId = this.getPromotionId();
        String other$promotionId = other.getPromotionId();
        if (this$promotionId == null ? other$promotionId != null : !this$promotionId.equals(other$promotionId)) {
            return false;
        }
        String this$afterSaleStatus = this.getAfterSaleStatus();
        String other$afterSaleStatus = other.getAfterSaleStatus();
        if (this$afterSaleStatus == null ? other$afterSaleStatus != null : !this$afterSaleStatus.equals(other$afterSaleStatus)) {
            return false;
        }
        String this$complainStatus = this.getComplainStatus();
        String other$complainStatus = other.getComplainStatus();
        if (this$complainStatus == null ? other$complainStatus != null : !this$complainStatus.equals(other$complainStatus)) {
            return false;
        }
        String this$orderPromotionType = this.getOrderPromotionType();
        String other$orderPromotionType = other.getOrderPromotionType();
        if (this$orderPromotionType == null ? other$orderPromotionType != null : !this$orderPromotionType.equals(other$orderPromotionType)) {
            return false;
        }
        String this$flowPrice = this.getFlowPrice();
        String other$flowPrice = other.getFlowPrice();
        if (this$flowPrice == null ? other$flowPrice != null : !this$flowPrice.equals(other$flowPrice)) {
            return false;
        }
        String this$consigneeMobile = this.getConsigneeMobile();
        String other$consigneeMobile = other.getConsigneeMobile();
        if (this$consigneeMobile == null ? other$consigneeMobile != null : !this$consigneeMobile.equals(other$consigneeMobile)) {
            return false;
        }
        Map<String, List<String>> this$inColumnValueMap = this.getInColumnValueMap();
        Map<String, List<String>> other$inColumnValueMap = other.getInColumnValueMap();
        return !(this$inColumnValueMap == null ? other$inColumnValueMap != null : !((Object)this$inColumnValueMap).equals(other$inColumnValueMap));
    }

    protected boolean canEqual(Object other) {
        return other instanceof OrderSearchParams;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $goodsName = this.getGoodsName();
        result = result * 59 + ($goodsName == null ? 43 : $goodsName.hashCode());
        String $orderSn = this.getOrderSn();
        result = result * 59 + ($orderSn == null ? 43 : $orderSn.hashCode());
        String $tag = this.getTag();
        result = result * 59 + ($tag == null ? 43 : $tag.hashCode());
        String $storeId = this.getStoreId();
        result = result * 59 + ($storeId == null ? 43 : $storeId.hashCode());
        String $memberId = this.getMemberId();
        result = result * 59 + ($memberId == null ? 43 : $memberId.hashCode());
        String $shipName = this.getShipName();
        result = result * 59 + ($shipName == null ? 43 : $shipName.hashCode());
        String $buyerName = this.getBuyerName();
        result = result * 59 + ($buyerName == null ? 43 : $buyerName.hashCode());
        String $orderStatus = this.getOrderStatus();
        result = result * 59 + ($orderStatus == null ? 43 : $orderStatus.hashCode());
        String $payStatus = this.getPayStatus();
        result = result * 59 + ($payStatus == null ? 43 : $payStatus.hashCode());
        String $keywords = this.getKeywords();
        result = result * 59 + ($keywords == null ? 43 : $keywords.hashCode());
        String $paymentType = this.getPaymentType();
        result = result * 59 + ($paymentType == null ? 43 : $paymentType.hashCode());
        String $orderType = this.getOrderType();
        result = result * 59 + ($orderType == null ? 43 : $orderType.hashCode());
        String $paymentMethod = this.getPaymentMethod();
        result = result * 59 + ($paymentMethod == null ? 43 : $paymentMethod.hashCode());
        Date $paymentTime = this.getPaymentTime();
        result = result * 59 + ($paymentTime == null ? 43 : ((Object)$paymentTime).hashCode());
        Date $startDate = this.getStartDate();
        result = result * 59 + ($startDate == null ? 43 : ((Object)$startDate).hashCode());
        Date $leCreateTime = this.getLeCreateTime();
        result = result * 59 + ($leCreateTime == null ? 43 : ((Object)$leCreateTime).hashCode());
        Date $leLogisticsTime = this.getLeLogisticsTime();
        result = result * 59 + ($leLogisticsTime == null ? 43 : ((Object)$leLogisticsTime).hashCode());
        Date $leCompleteTime = this.getLeCompleteTime();
        result = result * 59 + ($leCompleteTime == null ? 43 : ((Object)$leCompleteTime).hashCode());
        Date $endDate = this.getEndDate();
        result = result * 59 + ($endDate == null ? 43 : ((Object)$endDate).hashCode());
        String $clientType = this.getClientType();
        result = result * 59 + ($clientType == null ? 43 : $clientType.hashCode());
        String $commentStatus = this.getCommentStatus();
        result = result * 59 + ($commentStatus == null ? 43 : $commentStatus.hashCode());
        String $parentOrderSn = this.getParentOrderSn();
        result = result * 59 + ($parentOrderSn == null ? 43 : $parentOrderSn.hashCode());
        String $promotionId = this.getPromotionId();
        result = result * 59 + ($promotionId == null ? 43 : $promotionId.hashCode());
        String $afterSaleStatus = this.getAfterSaleStatus();
        result = result * 59 + ($afterSaleStatus == null ? 43 : $afterSaleStatus.hashCode());
        String $complainStatus = this.getComplainStatus();
        result = result * 59 + ($complainStatus == null ? 43 : $complainStatus.hashCode());
        String $orderPromotionType = this.getOrderPromotionType();
        result = result * 59 + ($orderPromotionType == null ? 43 : $orderPromotionType.hashCode());
        String $flowPrice = this.getFlowPrice();
        result = result * 59 + ($flowPrice == null ? 43 : $flowPrice.hashCode());
        String $consigneeMobile = this.getConsigneeMobile();
        result = result * 59 + ($consigneeMobile == null ? 43 : $consigneeMobile.hashCode());
        Map<String, List<String>> $inColumnValueMap = this.getInColumnValueMap();
        result = result * 59 + ($inColumnValueMap == null ? 43 : ((Object)$inColumnValueMap).hashCode());
        return result;
    }

    public String getGoodsName() {
        return this.goodsName;
    }

    public String getOrderSn() {
        return this.orderSn;
    }

    public String getTag() {
        return this.tag;
    }

    public String getStoreId() {
        return this.storeId;
    }

    public String getMemberId() {
        return this.memberId;
    }

    public String getShipName() {
        return this.shipName;
    }

    public String getBuyerName() {
        return this.buyerName;
    }

    public String getOrderStatus() {
        return this.orderStatus;
    }

    public String getPayStatus() {
        return this.payStatus;
    }

    public String getKeywords() {
        return this.keywords;
    }

    public String getPaymentType() {
        return this.paymentType;
    }

    public String getOrderType() {
        return this.orderType;
    }

    public String getPaymentMethod() {
        return this.paymentMethod;
    }

    public Date getPaymentTime() {
        return this.paymentTime;
    }

    public Date getStartDate() {
        return this.startDate;
    }

    public Date getLeCreateTime() {
        return this.leCreateTime;
    }

    public Date getLeLogisticsTime() {
        return this.leLogisticsTime;
    }

    public Date getLeCompleteTime() {
        return this.leCompleteTime;
    }

    public Date getEndDate() {
        return this.endDate;
    }

    public String getClientType() {
        return this.clientType;
    }

    public String getCommentStatus() {
        return this.commentStatus;
    }

    public String getParentOrderSn() {
        return this.parentOrderSn;
    }

    public String getPromotionId() {
        return this.promotionId;
    }

    public String getAfterSaleStatus() {
        return this.afterSaleStatus;
    }

    public String getComplainStatus() {
        return this.complainStatus;
    }

    public String getOrderPromotionType() {
        return this.orderPromotionType;
    }

    public String getFlowPrice() {
        return this.flowPrice;
    }

    public String getConsigneeMobile() {
        return this.consigneeMobile;
    }

    public Map<String, List<String>> getInColumnValueMap() {
        return this.inColumnValueMap;
    }

    public void setGoodsName(String goodsName) {
        this.goodsName = goodsName;
    }

    public void setOrderSn(String orderSn) {
        this.orderSn = orderSn;
    }

    public void setTag(String tag) {
        this.tag = tag;
    }

    public void setStoreId(String storeId) {
        this.storeId = storeId;
    }

    public void setMemberId(String memberId) {
        this.memberId = memberId;
    }

    public void setShipName(String shipName) {
        this.shipName = shipName;
    }

    public void setBuyerName(String buyerName) {
        this.buyerName = buyerName;
    }

    public void setOrderStatus(String orderStatus) {
        this.orderStatus = orderStatus;
    }

    public void setPayStatus(String payStatus) {
        this.payStatus = payStatus;
    }

    public void setKeywords(String keywords) {
        this.keywords = keywords;
    }

    public void setPaymentType(String paymentType) {
        this.paymentType = paymentType;
    }

    public void setOrderType(String orderType) {
        this.orderType = orderType;
    }

    public void setPaymentMethod(String paymentMethod) {
        this.paymentMethod = paymentMethod;
    }

    @JsonFormat(timezone="GMT+8", pattern="yyyy-MM-dd HH:mm:ss")
    public void setPaymentTime(Date paymentTime) {
        this.paymentTime = paymentTime;
    }

    @JsonFormat(timezone="GMT+8", pattern="yyyy-MM-dd HH:mm:ss")
    public void setStartDate(Date startDate) {
        this.startDate = startDate;
    }

    @JsonFormat(timezone="GMT+8", pattern="yyyy-MM-dd HH:mm:ss")
    public void setLeCreateTime(Date leCreateTime) {
        this.leCreateTime = leCreateTime;
    }

    @JsonFormat(timezone="GMT+8", pattern="yyyy-MM-dd HH:mm:ss")
    public void setLeLogisticsTime(Date leLogisticsTime) {
        this.leLogisticsTime = leLogisticsTime;
    }

    @JsonFormat(timezone="GMT+8", pattern="yyyy-MM-dd HH:mm:ss")
    public void setLeCompleteTime(Date leCompleteTime) {
        this.leCompleteTime = leCompleteTime;
    }

    @JsonFormat(timezone="GMT+8", pattern="yyyy-MM-dd HH:mm:ss")
    public void setEndDate(Date endDate) {
        this.endDate = endDate;
    }

    public void setClientType(String clientType) {
        this.clientType = clientType;
    }

    public void setCommentStatus(String commentStatus) {
        this.commentStatus = commentStatus;
    }

    public void setParentOrderSn(String parentOrderSn) {
        this.parentOrderSn = parentOrderSn;
    }

    public void setPromotionId(String promotionId) {
        this.promotionId = promotionId;
    }

    public void setAfterSaleStatus(String afterSaleStatus) {
        this.afterSaleStatus = afterSaleStatus;
    }

    public void setComplainStatus(String complainStatus) {
        this.complainStatus = complainStatus;
    }

    public void setOrderPromotionType(String orderPromotionType) {
        this.orderPromotionType = orderPromotionType;
    }

    public void setFlowPrice(String flowPrice) {
        this.flowPrice = flowPrice;
    }

    public void setConsigneeMobile(String consigneeMobile) {
        this.consigneeMobile = consigneeMobile;
    }

    public void setInColumnValueMap(Map<String, List<String>> inColumnValueMap) {
        this.inColumnValueMap = inColumnValueMap;
    }

    public String toString() {
        return "OrderSearchParams(goodsName=" + this.getGoodsName() + ", orderSn=" + this.getOrderSn() + ", tag=" + this.getTag() + ", storeId=" + this.getStoreId() + ", memberId=" + this.getMemberId() + ", shipName=" + this.getShipName() + ", buyerName=" + this.getBuyerName() + ", orderStatus=" + this.getOrderStatus() + ", payStatus=" + this.getPayStatus() + ", keywords=" + this.getKeywords() + ", paymentType=" + this.getPaymentType() + ", orderType=" + this.getOrderType() + ", paymentMethod=" + this.getPaymentMethod() + ", paymentTime=" + this.getPaymentTime() + ", startDate=" + this.getStartDate() + ", leCreateTime=" + this.getLeCreateTime() + ", leLogisticsTime=" + this.getLeLogisticsTime() + ", leCompleteTime=" + this.getLeCompleteTime() + ", endDate=" + this.getEndDate() + ", clientType=" + this.getClientType() + ", commentStatus=" + this.getCommentStatus() + ", parentOrderSn=" + this.getParentOrderSn() + ", promotionId=" + this.getPromotionId() + ", afterSaleStatus=" + this.getAfterSaleStatus() + ", complainStatus=" + this.getComplainStatus() + ", orderPromotionType=" + this.getOrderPromotionType() + ", flowPrice=" + this.getFlowPrice() + ", consigneeMobile=" + this.getConsigneeMobile() + ", inColumnValueMap=" + this.getInColumnValueMap() + ")";
    }
}

