/*
 * Decompiled with CFR 0.152.
 */
package cn.lili.modules.promotion.client;

import cn.lili.cache.CachePrefix;
import cn.lili.common.enums.PromotionTypeEnum;
import cn.lili.modules.order.cart.entity.vo.CartSkuVO;
import cn.lili.modules.promotion.entity.dos.PromotionGoods;
import cn.lili.modules.promotion.entity.dto.PromotionGoodsSearchPageDTO;
import cn.lili.modules.promotion.entity.dto.search.PromotionGoodsSearchParams;
import cn.lili.modules.promotion.fallback.PromotionGoodsFallback;
import cn.lili.modules.store.entity.dos.Store;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import java.util.Date;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

@FeignClient(name="promotion-service", contextId="promotion-goods", fallback=PromotionGoodsFallback.class)
public interface PromotionGoodsClient {
    @GetMapping(value={"/feign/promotion/promotion-goods/getPromotionGoodsStockCacheKey"})
    public static String getPromotionGoodsStockCacheKey(@RequestParam PromotionTypeEnum typeEnum, @RequestParam String promotionId, @RequestParam String skuId) {
        return "{" + CachePrefix.PROMOTION_GOODS_STOCK.name() + "_" + typeEnum.name() + "}_" + promotionId + "_" + skuId;
    }

    @GetMapping(value={"/feign/promotion/promotion-goods/valid/promotion/{skuId}"})
    public List<PromotionGoods> findSkuValidPromotion(@PathVariable String var1, @RequestParam String var2);

    @PostMapping(value={"/feign/promotion/promotion-goods/listFindAll"})
    public List<PromotionGoods> listFindAll(@RequestBody PromotionGoodsSearchParams var1);

    @PostMapping(value={"/feign/promotion/promotion-goods/pageFindAll"})
    public Page<PromotionGoods> pageFindAll(@RequestBody PromotionGoodsSearchPageDTO var1);

    @PostMapping(value={"/feign/promotion/promotion-goods/getPromotionsGoods"})
    public PromotionGoods getPromotionsGoods(@RequestBody PromotionGoodsSearchParams var1);

    @PostMapping(value={"/feign/promotion/promotion-goods/{skuId}/valid"})
    public PromotionGoods getValidPromotionsGoods(@PathVariable String var1, @RequestBody List<String> var2);

    @PostMapping(value={"/feign/promotion/promotion-goods/{skuId}/valid/price"})
    public Double getValidPromotionsGoodsPrice(@PathVariable String var1, @RequestBody List<String> var2);

    @GetMapping(value={"/feign/promotion/promotion-goods/inner-overlap/{skuId}"})
    public Integer findInnerOverlapPromotionGoods(@RequestParam String var1, @PathVariable String var2, @RequestParam Date var3, @RequestParam Date var4, @RequestParam String var5);

    @GetMapping(value={"/feign/promotion/promotion-goods/{promotionId}/{skuId}/stock"})
    public Integer getPromotionGoodsStock(@RequestParam PromotionTypeEnum var1, @PathVariable String var2, @PathVariable String var3);

    @GetMapping(value={"/feign/promotion/promotion-goods/{promotionId}"})
    public List<Integer> getPromotionGoodsStock(@RequestParam PromotionTypeEnum var1, @PathVariable String var2, @RequestParam List<String> var3);

    @PutMapping(value={"/feign/promotion/promotion-goods/stock"})
    public void updatePromotionGoodsStock(@RequestBody List<PromotionGoods> var1);

    @PutMapping(value={"/feign/promotion/promotion-goods/stock/quantity"})
    public void updatePromotionGoodsStock(@RequestParam String var1, @RequestParam Integer var2);

    @PutMapping(value={"/feign/promotion/promotion-goods/updatePromotionGoodsByPromotions"})
    public void updatePromotionGoodsByPromotions(@RequestBody PromotionGoods var1);

    @DeleteMapping(value={"/feign/promotion/promotion-goods/{promotionId}"})
    public void deletePromotionGoods(@PathVariable String var1, @RequestBody List<String> var2);

    @DeleteMapping(value={"/feign/promotion/promotion-goods/deletePromotionGoodsIds"})
    public void deletePromotionGoods(@RequestBody List<String> var1);

    @DeleteMapping(value={"/feign/promotion/promotion-goods/deletePromotionGoods"})
    public void deletePromotionGoods(@RequestBody PromotionGoodsSearchParams var1);

    @PutMapping(value={"/feign/promotion/promotion-goods/updateBatchById"})
    public void updateBatchById(@RequestBody List<PromotionGoods> var1);

    @PutMapping(value={"/feign/promotion/promotion-goods/getCurrentGoodsPromotion/{cartType}"})
    public CartSkuVO getCurrentGoodsPromotion(@RequestBody CartSkuVO var1, @PathVariable String var2);

    @PutMapping(value={"/feign/promotion/promotion-goods/updateStoreName"})
    public void updateStoreName(@RequestBody Store var1);
}

