package cn.lili.feign;

import cn.hutool.json.JSONObject;
import cn.hutool.json.JSONUtil;
import cn.lili.common.enums.ResultCode;
import cn.lili.common.exception.ServiceException;
import feign.Response;
import feign.Util;
import feign.codec.ErrorDecoder;
import org.springframework.context.annotation.Configuration;

import java.io.IOException;
import java.nio.charset.Charset;

/**
 * 转发服务见调用时的触发异常
 *
 * @author paulG
 * @since 2022/7/27
 **/
@Configuration
public class FeignErrorDecoder implements ErrorDecoder {

    @Override
    public Exception decode(final String methodKey, final Response response) {
        try {
            String message = Util.toString(response.body().asReader(Charset.defaultCharset()));
            JSONObject jsonObject = JSONUtil.parseObj(message);
            return new ServiceException(ResultCode.getResultByCode(jsonObject.getInt("code")), jsonObject.getStr("message"));
        } catch (IOException e) {
            e.printStackTrace();
        }
        return decode(methodKey, response);
    }
}
