package cn.lili.modules.distribution.client;

import cn.lili.modules.constant.ServiceConstant;
import cn.lili.modules.distribution.fallback.DistributionCashStatisticsFallback;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;

/**
 * @author paulG
 * @since 2022/6/28
 **/
@FeignClient(name = ServiceConstant.DISTRIBUTION_SERVICE, contextId = "distribution-cash-statistics", fallback = DistributionCashStatisticsFallback.class)
public interface DistributionCashStatisticsClient {

    /**
     * 待处理分销员提现申请数量
     *
     * @return 待处理分销员提现申请数量
     */
    @GetMapping("/feign/distribution-goods/statistics/newDistributionCash")
    long newDistributionCash();

}
