package cn.lili.modules.distribution.client;

import cn.lili.modules.constant.ServiceConstant;
import cn.lili.modules.distribution.entity.dos.DistributionGoods;
import cn.lili.modules.distribution.entity.dto.DistributionGoodsSearchParams;
import cn.lili.modules.distribution.fallback.DistributionGoodsFallback;
import cn.lili.modules.store.entity.dos.Store;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * 商品服务分销商品client
 *
 * @author Chopper
 * @version v1.0 2021-11-08 09:52
 */
@FeignClient(name = ServiceConstant.DISTRIBUTION_SERVICE, contextId = "distribution-goods", fallback = DistributionGoodsFallback.class)
public interface DistributionGoodsClient {

    /**
     * 校验分校商品
     *
     * @param skuIds
     * @return
     */
    @PostMapping("/feign/distribution-goods/check")
    List<DistributionGoods> distributionGoods(@RequestBody List<String> skuIds);

    @PostMapping("/feign/distribution-goods/getDistributionGoods")
    DistributionGoods getDistributionGoods(@RequestBody DistributionGoodsSearchParams searchParams);

    @GetMapping("/feign/distribution-goods/removeById/{id}")
    void removeById(@PathVariable String id);


    /**
     * 修改分销商品店铺名称
     *
     * @param store 店铺信息
     */
    @PutMapping("/feign/distribution-goods/updateStoreName")
    void updateStoreName(@RequestBody Store store);
}
