package cn.lili.modules.distribution.client;

import cn.hutool.core.date.DateTime;
import cn.lili.modules.constant.ServiceConstant;
import cn.lili.modules.distribution.entity.dos.DistributionOrder;
import cn.lili.modules.distribution.fallback.DistributionOrderFallBack;
import cn.lili.modules.order.order.entity.dos.OrderItem;
import cn.lili.modules.store.entity.dos.Store;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * @author: ftyy
 * @date: 2022-01-13 17:02
 * @description: 分销订单Client
 */
@FeignClient(name = ServiceConstant.DISTRIBUTION_SERVICE, contextId = "distribution-order", fallback = DistributionOrderFallBack.class)
public interface DistributionOrderClient {

    /**
     * 支付订单 记录分销订单
     *
     * @param orderSn 订单编号
     */
    @GetMapping("/feign/distribution-order/calculationDistribution")
    void calculationDistribution(@RequestParam String orderSn);

    /**
     * 取消订单 记录分销订单
     *
     * @param orderSn 订单编号
     */
    @GetMapping("/feign/distribution-order/cancelOrder")
    void cancelOrder(@RequestParam String orderSn);

    /**
     * 订单退款 记录分销订单
     *
     * @param afterSaleSn 售后单号
     */
    @GetMapping("/feign/distribution-order/refundOrder")
    void refundOrder(@RequestParam String afterSaleSn);

    @GetMapping("/feign/distribution-order/rebate")
    void rebate(@RequestParam String name, @RequestParam DateTime dateTime);

    @PutMapping("/feign/distribution-order/update")
    void update(@RequestBody DistributionOrder distributionOrder);

    @PutMapping("/feign/distribution-order/updateDistributionOrderStatus")
    void updateDistributionOrderStatus(@RequestBody List<OrderItem> orderItems);

    /**
     * 分销结算订单
     *
     * @param dateTime
     * @param distributionOrderStatus
     */
    @PutMapping("/feign/distribution-order/updateRebate/{distributionOrderStatus}")
    void updateRebate(@RequestBody DateTime dateTime, @PathVariable String distributionOrderStatus);

    /**
     * 修改分销订单店铺名称
     *
     * @param store 店铺信息
     */
    @PutMapping("/feign/distribution-order/updateStoreName")
    void updateStoreName(@RequestBody Store store);
}
