package cn.lili.modules.distribution.fallback;

import cn.hutool.core.date.DateTime;
import cn.lili.common.enums.ResultCode;
import cn.lili.common.exception.ServiceException;
import cn.lili.modules.distribution.client.DistributionOrderClient;
import cn.lili.modules.distribution.entity.dos.DistributionOrder;
import cn.lili.modules.order.order.entity.dos.OrderItem;
import cn.lili.modules.store.entity.dos.Store;
import org.springframework.stereotype.Component;

import java.util.List;

/**
 * @author: ftyy
 * @date: 2022-01-13 17:07
 * @description: 分销订单Fallback
 */
@Component
public class DistributionOrderFallBack implements DistributionOrderClient {

    @Override
    public void calculationDistribution(String orderSn) {
        throw new ServiceException(ResultCode.ERROR);
    }

    @Override
    public void cancelOrder(String orderSn) {
        throw new ServiceException(ResultCode.ERROR);
    }

    @Override
    public void refundOrder(String afterSaleSn) {
        throw new ServiceException(ResultCode.ERROR);
    }

    @Override
    public void rebate(String name, DateTime dateTime) {
        throw new ServiceException(ResultCode.ERROR);
    }

    @Override
    public void update(DistributionOrder distributionOrder) {
        throw new ServiceException(ResultCode.ERROR);
    }

    @Override
    public void updateDistributionOrderStatus(List<OrderItem> orderItems) {
        throw new ServiceException(ResultCode.ERROR);
    }

    @Override
    public void updateRebate(DateTime dateTime, String distributionOrderStatus) {
        throw new ServiceException(ResultCode.ERROR);
    }

    @Override
    public void updateStoreName(Store store) {
        throw new ServiceException(ResultCode.ERROR);
    }


}
