package cn.lili.modules.fulllinklog.client;

import cn.lili.modules.constant.ServiceConstant;
import cn.lili.modules.fulllinklog.entity.FullLinkLogDTO;
import cn.lili.modules.goods.fallback.BrandFallback;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestParam;

/**
 * @Author yuquanfeng
 * @Date 2023/6/11
 * @Description
 **/
@FeignClient(name = ServiceConstant.GOODS_SERVICE, contextId = "fulllinklog", fallback = BrandFallback.class)

public interface FullLinkLogClient {
    /**
     * 查询全链路日志
     * @param rid
     * @return
     */
    @GetMapping("/feign/fulllinklog")
    FullLinkLogDTO queryFullLinkLogByRid(@RequestParam String rid);

}
