package cn.lili.modules.goods.client;

import cn.lili.modules.constant.ServiceConstant;
import cn.lili.modules.goods.entity.dto.AdvertLinkDTO;
import cn.lili.modules.goods.fallback.AdvertLinkFallback;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestParam;

/**
 * @Author yuquanfeng
 * @Date 2023/8/11
 * @Description
 **/
@FeignClient(name = ServiceConstant.GOODS_SERVICE, contextId = "advertLink", fallback = AdvertLinkFallback.class)
public interface AdvertLinkClient {
    @GetMapping("/feign/goods/advertLink/queryAdvertLink")
    AdvertLinkDTO queryAdvertLink(@RequestParam Long advertLinkId);

    @GetMapping("/feign/goods/advertLink/queryByStockId")
    AdvertLinkDTO queryAdvertLinkIdByStockId(@RequestParam String stockId);

}
