package cn.lili.modules.goods.client;

import cn.lili.modules.constant.ServiceConstant;
import cn.lili.modules.goods.entity.dos.Brand;
import cn.lili.modules.goods.entity.vos.BrandVO;
import cn.lili.modules.goods.fallback.BrandFallback;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * @author: ftyy
 * @date: 2022-01-14 10:38
 * @description: 商品品牌Client
 */
@FeignClient(name = ServiceConstant.GOODS_SERVICE, contextId = "brand", fallback = BrandFallback.class)
public interface BrandClient {

    /**
     * 删除品牌
     *
     * @param ids 品牌id
     */
    @DeleteMapping("/feign/goods/brand/deleteBrands")
    void deleteBrands(@RequestBody List<String> ids);

    /**
     * 根据分类ID获取品牌列表
     *
     * @param categoryId 分类ID
     * @return 品牌列表
     */
    @GetMapping("/feign/goods/brand/getBrandsByCategory")
    List<Brand> getBrandsByCategory(@RequestParam String categoryId);

    /**
     * 添加品牌
     *
     * @param brandVO 品牌信息
     * @return 添加结果
     */
    @PutMapping("/feign/goods/brand/addBrand")
    boolean addBrand(@RequestBody BrandVO brandVO);

    /**
     * 更新品牌
     *
     * @param brandVO 品牌信息
     * @return 更新结果
     */
    @PutMapping("/feign/goods/brand/updateBrand")
    boolean updateBrand(@RequestBody BrandVO brandVO);

    /**
     * 更新品牌是否可用
     *
     * @param brandId 品牌ID
     * @param disable 是否不可用
     * @return 更新结果
     */
    @GetMapping("/feign/goods/brand/brandDisable")
    boolean brandDisable(@RequestParam String brandId, @RequestParam boolean disable);

    @GetMapping("/feign/goods/brand/getById")
    Brand getById(@RequestParam String brandId);
}
