package cn.lili.modules.goods.client;

import cn.lili.modules.constant.ServiceConstant;
import cn.lili.modules.goods.fallback.GoodsCollectionFallback;
import cn.lili.modules.member.entity.dos.GoodsCollection;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * @author: ftyy
 * @date: 2022-01-14 10:22
 * @description: 会员商品收藏Client
 */
@FeignClient(name = ServiceConstant.GOODS_SERVICE, contextId = "goods-collection", fallback = GoodsCollectionFallback.class)
public interface GoodsCollectionClient {

    /**
     * 是否收藏商品
     *
     * @param skuId 规格ID
     * @return 是否收藏
     */
    @GetMapping("/feign/member/goods-collection/isCollection/{skuId}")
    boolean isCollection(@PathVariable String skuId);

    /**
     * 添加商品收藏
     *
     * @param skuId 规格ID
     * @return 操作状态
     */
    @PostMapping("/feign/member/goods-collection/addGoodsCollection/{skuId}")
    GoodsCollection addGoodsCollection(@PathVariable String skuId);

    /**
     * 商品收藏
     *
     * @param skuId 规格ID
     * @return 操作状态
     */
    @DeleteMapping("/feign/member/goods-collection/{skuId}")
    boolean deleteGoodsCollection(@PathVariable String skuId);

    /**
     * 删除商品收藏
     *
     * @param goodsIds 规格ID
     * @return 操作状态
     */
    @DeleteMapping("/feign/member/goods-collection")
    boolean deleteGoodsCollection(@RequestBody List<String> goodsIds);

    /**
     * 删除商品SKU收藏
     *
     * @param skuIds 规格ID
     * @return 操作状态
     */
    @DeleteMapping("/feign/member/goods-collection/deleteSkuCollection")
    boolean deleteSkuCollection(@RequestBody List<String> skuIds);
}
