package cn.lili.modules.goods.client;

import cn.lili.modules.constant.ServiceConstant;
import cn.lili.modules.goods.entity.dto.GoodsServiceCommitmentDTO;
import cn.lili.modules.goods.fallback.GoodsServiceCommitmentFallback;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestParam;

/**
 * @Author yuquanfeng
 * @Date 2023/9/12
 * @Description
 **/
@FeignClient(name = ServiceConstant.GOODS_SERVICE, contextId = "goods-service", fallback = GoodsServiceCommitmentFallback.class)
public interface GoodsServiceCommitmentClient {

    @GetMapping("/feign/goods/goods-service/queryByGoodsId")
    GoodsServiceCommitmentDTO queryByGoodsId(@RequestParam("goodsId") Long goodsId);

}
