package cn.lili.modules.goods.client;

import cn.lili.modules.constant.ServiceConstant;
import cn.lili.modules.goods.entity.dto.MarketingComponentsDTO;
import cn.lili.modules.goods.fallback.MarketingComponentsFallback;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestParam;

/**
 * @Author yuquanfeng
 * @Date 2023/9/12
 * @Description
 **/
@FeignClient(name = ServiceConstant.GOODS_SERVICE, contextId = "market-components", fallback = MarketingComponentsFallback.class)

public interface MarketingComponentsClient {

    @GetMapping("/feign/goods/market-components/queryById")
    MarketingComponentsDTO queryById(@RequestParam("id") Long id);
}
