package cn.lili.modules.goods.client;

import cn.lili.modules.constant.ServiceConstant;
import cn.lili.modules.goods.entity.dto.ReturnStrategyDTO;
import cn.lili.modules.goods.fallback.ReturnStrategyFallback;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestParam;

/**
 * @Author yuquanfeng
 * @Date 2023/6/12
 * @Description
 **/
@FeignClient(name = ServiceConstant.GOODS_SERVICE, contextId = "returnStrategy", fallback = ReturnStrategyFallback.class)

public interface ReturnStrategyClient {

    @GetMapping("/feign/returnStrategy/get")
    ReturnStrategyDTO getReturnStrategyByAdvertLinkId(@RequestParam Long advertLinkId);
}
