package cn.lili.modules.goods.client;

import cn.lili.modules.constant.ServiceConstant;
import cn.lili.modules.goods.entity.dos.StudioCommodity;
import cn.lili.modules.goods.fallback.StudioCommodityFallback;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;

/**
 * @author: ftyy
 * @date: 2022-01-17 16:05
 * @description: 直播间商品Client
 */
@FeignClient(name = ServiceConstant.BROADCAST_SERVICE, contextId = "studioCommodity",fallback = StudioCommodityFallback.class)
public interface StudioCommodityClient {

    @GetMapping("/feign/goods/studioCommodity/getOne")
    StudioCommodity getOne(@RequestParam Integer roomId, @RequestParam Integer goodsId);

    @PostMapping("/feign/goods/studioCommodity/save")
    void save(@RequestBody StudioCommodity studioCommodity);

    @DeleteMapping("/feign/goods/studioCommodity/studioCommodity")
    void remove(@RequestBody StudioCommodity studioCommodity);
}
