package cn.lili.modules.goods.client;

import cn.lili.modules.constant.ServiceConstant;
import cn.lili.modules.goods.entity.dto.SkuSuiteDTO;
import cn.lili.modules.goods.fallback.StudioCommodityFallback;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestParam;

/**
 * @Author yuquanfeng
 * @Date 2023/10/20
 * @Description
 **/
@FeignClient(name = ServiceConstant.GOODS_SERVICE, contextId = "suite",fallback = StudioCommodityFallback.class)

public interface SuiteClient {

    @GetMapping("/feign/goods/suite/getById")
    SkuSuiteDTO getById(@RequestParam Long suiteId);
}
