package cn.lili.modules.goods.entity.dos;

import cn.hutool.core.text.CharSequenceUtil;
import cn.lili.mybatis.BaseIdEntity;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.NoArgsConstructor;


/**
 * 直播间商品
 *
 * @author Bulbasaur
 * @since 2021/5/18 5:42 下午
 */
@Data
@ApiModel(value = "直播间商品")
@TableName("li_studio_commodity")
@NoArgsConstructor
public class StudioCommodity extends BaseIdEntity {

    private static final long serialVersionUID = 8179291212071954019L;
    @ApiModelProperty(value = "房间ID")
    private Integer roomId;

    @ApiModelProperty(value = "商品ID")
    private Integer goodsId;

    public StudioCommodity(Integer roomId, Integer goodsId) {
        this.roomId = roomId;
        this.goodsId = goodsId;
    }

    public LambdaQueryWrapper<StudioCommodity> lambdaQueryWrapper(){
        LambdaQueryWrapper<StudioCommodity> lambdaQueryWrapper = new LambdaQueryWrapper<>();
        //id
        if (CharSequenceUtil.isNotEmpty(this.getId())) {
            lambdaQueryWrapper.eq(StudioCommodity::getId, this.getId());
        }
        //房间id
        if (this.roomId!=null && !this.roomId.equals("")) {
            lambdaQueryWrapper.eq(StudioCommodity::getRoomId,this.roomId);
        }
        //商品id
        if(this.goodsId!=null && !this.goodsId.equals("")){
            lambdaQueryWrapper.eq(StudioCommodity::getGoodsId,this.goodsId);
        }

        return lambdaQueryWrapper;
    }
}
