package cn.lili.modules.goods.entity.dto;

import cn.lili.modules.goods.entity.dos.GoodsSku;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import org.springframework.beans.BeanUtils;

import java.util.List;

/**
 * @author paulG
 * @since 2022/1/19
 **/
@EqualsAndHashCode(callSuper = true)
@Data
@NoArgsConstructor
@AllArgsConstructor
public class GoodsSkuDTO extends GoodsSku {

    private static final long serialVersionUID = -5576819167713999104L;

    private List<GoodsParamsDTO> goodsParamDTOS;

    @ApiModelProperty(value = "商品参数json")
    private String params;

    public GoodsSkuDTO(GoodsSku goodsSku, List<GoodsParamsDTO> goodsParamDTOS) {
        BeanUtils.copyProperties(goodsSku, this);
        this.goodsParamDTOS = goodsParamDTOS;
    }
}
