package cn.lili.modules.goods.fallback;

import cn.lili.common.enums.ResultCode;
import cn.lili.common.exception.ServiceException;
import cn.lili.modules.goods.client.CommodityClient;
import cn.lili.modules.goods.entity.dos.Commodity;
import org.springframework.stereotype.Component;

import java.util.List;

/**
 * @author paulG
 * @since 2022/1/14
 **/
@Component
public class CommodityFallback implements CommodityClient {

    /**
     * 添加直播商品
     *
     * @param commodity 直播商品列表
     * @return 添加结果
     */
    @Override
    public boolean addCommodity(List<Commodity> commodity) {
        throw new ServiceException(ResultCode.ERROR);
    }

    /**
     * 查询微信小程序直播商品审核状态
     */
    @Override
    public void getGoodsWareHouse() {
        throw new ServiceException(ResultCode.ERROR);
    }

    @Override
    public boolean deleteCommodity(String goodsId) {
        throw new ServiceException(ResultCode.ERROR);
    }
}
