package cn.lili.modules.logistics.entity.enums;

import lombok.Getter;

/**
 * @Author yuquanfeng
 * @Date 2023/9/20
 * @Description
 **/
@Getter
public enum Kuaidi100LogisticsCodeEnum {

    LANSHOU("1", "揽收", 1, "揽收"),
    YIXIADAN("101", "已下单", 1, "揽收"),
    DAILANSHOU("102", "待揽收", 1, "揽收"),
    YILANSHOU("103", "已揽收", 1, "揽收"),

    ZAITU("0", "在途", 0, "在途"),
    DAODAPAIJIANCHENGSHI("1001", "到达派件城市", 0, "在途"),
    GANXIAN("1002", "干线", 0, "在途"),

    PAIJIAN("5", "派件", 5, "派件"),
    TOUGUIHUOYIZHAN("501", "投柜或驿站", 5, "派件"),

    QIANSHOU("3", "签收", 3, "签收"),
    BENRENQIANSHOU("301", "本人签收", 3, "签收"),
    PAIJIANYICHANGHOUQIANSHOU("302", "派件异常后签收", 3, "签收"),
    DAIQIAN("303", "代签", 3, "签收"),
    TOUGUIHUOZHANQIANSHOU("304", "投柜或站签收", 3, "签收"),

    TUIHUI("6", "退回", 6, "退回"),

    TUIQIAN("4", "退签", 4, "退签"),
    YIXIAODAN("401", "已销单", 4, "退签"),
    JUQIAN("14", "拒签", 4, "退签"),


    ZHUANTOU("7", "转投", 7, "转投"),

    YINAN("2", "疑难", 2, "疑难"),
    CHAOSHIWEIQIANSHOU("201", "超时未签收", 2, "疑难"),
    CHAOSHIWEIGENGXIN("202", "超时未更新", 2, "疑难"),
    JUSHOU("203", "拒收", 2, "疑难"),
    PAIJIANYICHANG("204", "派件异常", 2, "疑难"),
    GUIHUOYIZHANCHOASHIWEIQU("205", "柜或驿站超时未取", 2, "疑难"),
    WUFALIANXI("206", "无法联系", 2, "疑难"),
    CHAOQU("207", "超区", 2, "疑难"),
    ZHILIU("208", "滞留", 2, "疑难"),
    POSUN("209", "破损", 2, "疑难"),
    XIAODAN("210", "销单", 2, "疑难"),


    QINGGUAN("8", "清关", 8, "清关"),
    DAIQINGGUAN("8", "待清关", 8, "清关"),
    QINGGUANZHONG("8", "清关中", 8, "清关"),
    YIQINGGUAN("8", "已清关", 8, "清关"),
    QINGGUANYICHANG("8", "清关异常", 8, "清关"),
    ;

    private String status;

    private String desc;

    private Integer parentStatus;

    private String parentDesc;

    Kuaidi100LogisticsCodeEnum(String status, String desc, Integer parentStatus, String parentDesc){
        this.status = status;
        this.desc = desc;
        this.parentStatus = parentStatus;
        this.parentDesc = parentDesc;
    }

    public static Kuaidi100LogisticsCodeEnum getInstanceByStatus(String status) {
        if(status == null){
            return null;
        }
        for (Kuaidi100LogisticsCodeEnum kuaidi100LogisticsCodeEnum : Kuaidi100LogisticsCodeEnum.values()){
            if(kuaidi100LogisticsCodeEnum.getStatus().equals(status)){
                return kuaidi100LogisticsCodeEnum;
            }
        }
        return null;
    }
}
