package cn.lili.modules.member.client;

import cn.lili.modules.connect.entity.Connect;
import cn.lili.modules.constant.ServiceConstant;
import cn.lili.modules.member.entity.dto.ConnectQueryDTO;
import cn.lili.modules.member.fallback.ConnectFallback;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

/**
 * 联合登陆client
 *
 * @author liushuai(liushuai711 @ gmail.com)
 * @since 2021/12/7 08:23
 */
@FeignClient(
        name = ServiceConstant.MEMBER_SERVICE,
        contextId = "connect",
        fallback = ConnectFallback.class)
public interface ConnectClient {

    /**
     * 查询联合登陆信息
     *
     * @param connectQueryDTO 联合登陆DTO
     * @return 联合登陆模型
     */
    @PostMapping("/feign/member/connect/query")
    Connect queryConnect(@RequestBody ConnectQueryDTO connectQueryDTO);
}
