package cn.lili.modules.member.client;

import cn.lili.common.security.enums.UserEnums;
import cn.lili.common.vo.PageVO;
import cn.lili.modules.constant.ServiceConstant;
import cn.lili.modules.member.entity.dos.Member;
import cn.lili.modules.member.entity.dto.MemberSearchPageDTO;
import cn.lili.modules.member.entity.dto.MemberSearchParams;
import cn.lili.modules.member.entity.vo.MemberSearchVO;
import cn.lili.modules.member.entity.vo.MemberVO;
import cn.lili.modules.member.fallback.MemberFallback;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;

import java.util.List;
import java.util.Map;

/**
 * 会员服务client
 *
 * @author liushuai(liushuai711 @ gmail.com)
 * @since 2021/12/7 08:23
 */
@FeignClient(
        name = ServiceConstant.MEMBER_SERVICE,
        contextId = "member",
        fallback = MemberFallback.class)
public interface MemberClient {

    /**
     * 查询会员
     *
     * @param id 用户id
     * @return 会员
     */
    @GetMapping("/feign/member/query")
    Member getById(@RequestParam String id);

    @GetMapping("/feign/member/queryByCache")
    Member getByCache(@RequestParam String id);

    /**
     * 获取指定会员数据
     *
     * @param columns   指定获取的列
     * @param memberIds 会员ids
     * @return 指定会员数据
     */
    @GetMapping("/feign/member/query/field")
    List<Map<String, Object>> listFieldsByMemberIds(@RequestParam String columns, @RequestParam List<String> memberIds);

    /**
     * 登出
     *
     * @param userEnums token角色类型
     */
    @GetMapping("/feign/member/logout")
    void logout(@RequestParam UserEnums userEnums);

    /**
     * 获取所有会员的手机号
     *
     * @return 所有会员的手机号
     */
    @GetMapping("/feign/member/member/mobile")
    List<String> getAllMemberMobile();

    /**
     * 根据条件查询会员总数
     *
     * @param memberSearchVO
     * @return 会员总数
     */
    @PostMapping("/feign/member/member/getMemberNum")
    long getMemberNum(@RequestBody MemberSearchVO memberSearchVO);

    /**
     * 根据条件查询会员列表
     *
     * @param searchParams 查询参数
     * @return 会员列表
     */
    @PostMapping("/feign/member/member/list")
    List<Member> list(@RequestBody MemberSearchParams searchParams);

    /**
     * 会员积分变动
     *
     * @param point    变动积分
     * @param type     是否增加积分 INCREASE 增加 REDUCE 扣减
     * @param memberId 会员id
     * @param content  变动日志
     * @return 操作结果
     */
    @GetMapping("/feign/member/member/updateMemberPoint")
    Boolean updateMemberPoint(@RequestParam Long point, @RequestParam String type, @RequestParam String memberId, @RequestParam String content);

    /**
     * 更新会员登录时间为最新时间
     *
     * @param memberId 会员id
     * @return 是否更新成功
     */
    @PutMapping("/feign/member/member/updateMemberPoint")
    boolean updateMemberLoginTime(@RequestParam String memberId);


    @GetMapping("/feign/member/member/getMemberPoint/{memberId}")
    Long getMemberPoint(@PathVariable String memberId);

    @PostMapping("/feign/member/member/getMemberPage")
    Page<MemberVO> getMemberPage(@RequestBody MemberSearchPageDTO memberSearchVO);
}
