package cn.lili.modules.member.client;

import cn.lili.modules.constant.ServiceConstant;
import cn.lili.modules.member.entity.dto.EvaluationQueryParams;
import cn.lili.modules.member.entity.dto.MemberEvaluationDTO;
import cn.lili.modules.member.entity.vo.EvaluationNumberVO;
import cn.lili.modules.member.entity.vo.MemberEvaluationVO;
import cn.lili.modules.member.entity.vo.StoreRatingVO;
import cn.lili.modules.member.fallback.MemberEvaluationFallback;
import cn.lili.modules.store.entity.dos.Store;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;

import java.util.List;
import java.util.Map;

/**
 * @author: ftyy
 * @date: 2022-01-12 10:33
 * @description: 会员商品评价 Client
 */
@FeignClient(name = ServiceConstant.MEMBER_SERVICE, contextId = "member-evaluation", fallback = MemberEvaluationFallback.class)
public interface MemberEvaluationClient {

    /**
     * 添加会员评价
     * 1.检测用户是否重复评价
     * 2.获取评价相关信息添加评价
     * 3.修改子订单为已评价状态
     * 4.发送用户评价消息修改商品的评价数量以及好评率
     *
     * @param memberEvaluationDTO 评论
     * @return 操作状态
     */
    @PostMapping("/feign/member/member-evaluation/addMemberEvaluation")
    MemberEvaluationDTO addMemberEvaluation(@RequestBody MemberEvaluationDTO memberEvaluationDTO);

    /**
     * 根据ID查询会员评价
     *
     * @param id 评价ID
     * @return 会员评价
     */
    @GetMapping("/feign/member/member-evaluation/queryById")
    MemberEvaluationVO queryById(@RequestParam String id);

    /**
     * 更改评论状态
     *
     * @param id     评价ID
     * @param status 状态
     * @return 会员评价
     */
    @GetMapping("/feign/member/member-evaluation/updateStatus")
    boolean updateStatus(@RequestParam String id, @RequestParam String status);

    /**
     * 删除评论
     *
     * @param id 评论ID
     * @return 操作状态
     */
    @DeleteMapping("/feign/member/member-evaluation/delete")
    boolean delete(@RequestParam String id);

    /**
     * 商家回复评价
     *
     * @param id         评价ID
     * @param reply      回复内容
     * @param replyImage 回复图片
     * @return 操作状态
     */
    @GetMapping("/feign/member/member-evaluation/reply")
    boolean reply(@RequestParam String id, @RequestParam String reply, @RequestParam String replyImage);

    /**
     * 获取商品评价数量
     *
     * @param goodsId 商品ID
     * @return 评价数量数据
     */
    @GetMapping("/feign/member/member-evaluation/getEvaluationNumber")
    EvaluationNumberVO getEvaluationNumber(@RequestParam String goodsId);


    /**
     * 统计商品评价数量
     *
     * @param evaluationQueryParams 查询条件
     * @return 商品评价数量
     */
    @PostMapping("/feign/member/member-evaluation/count")
    long getEvaluationCount(@RequestBody EvaluationQueryParams evaluationQueryParams);

    /**
     * 商品会员评价数量
     *
     * @param evaluationQueryParams 查询条件
     * @return 评价数量
     */
    @PostMapping("/feign/member/member-evaluation/num")
    List<Map<String, Object>> memberEvaluationNum(@RequestBody EvaluationQueryParams evaluationQueryParams);

    /**
     * 获取店铺评分
     *
     * @param evaluationQueryParams 查询条件
     * @return 店铺评分
     */
    @PostMapping("/feign/member/member-evaluation/rating")
    StoreRatingVO getStoreRatingVO(@RequestBody EvaluationQueryParams evaluationQueryParams);

    /**
     * 修改会员评价中店铺名称
     *
     * @param store 店铺信息
     */
    @PutMapping("/feign/member-evaluation/updateStoreName")
    void updateStoreName(@RequestBody Store store);
}
