package cn.lili.modules.member.client;

import cn.lili.modules.constant.ServiceConstant;
import cn.lili.modules.member.fallback.MemberEvaluationStatisticsFallback;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestParam;

/**
 * @author paulG
 * @since 2022/6/24
 **/
@FeignClient(
        name = ServiceConstant.MEMBER_SERVICE,
        contextId = "member-evaluation-statistics",
        fallback = MemberEvaluationStatisticsFallback.class)
public interface MemberEvaluationStatisticsClient {

    /**
     * 获取今天新增的评价数量
     *
     * @return 今日评价数量
     */
    @GetMapping("/feign/member/member-evaluation/statistics/todayMemberEvaluation")
    long todayMemberEvaluation();

    /**
     * 获取等待回复评价数量
     *
     * @param storeId 店铺id
     * @return 等待回复评价数量
     */
    @GetMapping("/feign/member/member-evaluation/statistics/getWaitReplyNum")
    long getWaitReplyNum(@RequestParam String storeId);


}
