package cn.lili.modules.member.client;

import cn.lili.modules.constant.ServiceConstant;
import cn.lili.modules.member.entity.dto.MemberOpenIdDTO;
import cn.lili.modules.member.fallback.MemberOpenIdFallback;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestParam;

/**
 * @Author yuquanfeng
 * @Date 2023/11/3
 * @Description
 *
 **/
@FeignClient(
        name = ServiceConstant.MEMBER_SERVICE,
        contextId = "member-openId",
        fallback = MemberOpenIdFallback.class)
public interface MemberOpenIdnClient {

    @GetMapping("/feign/member/openId/queryByMemberIdAndAppId")
    MemberOpenIdDTO queryByMemberIdAndAppId(@RequestParam("memberId") String memberId, @RequestParam("appId") String appId);

    @GetMapping("/feign/member/openId/queryByMemberIdAndUnionId")
    MemberOpenIdDTO queryByMemberIdAndUnionId(@RequestParam("memberId") String memberId, @RequestParam("unionId") String unionId);

}
