package cn.lili.modules.member.client;

import cn.lili.modules.constant.ServiceConstant;
import cn.lili.modules.member.entity.dos.MemberSign;
import cn.lili.modules.member.fallback.MemberSignFallback;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;

/**
 * @author: ftyy
 * @date: 2022-01-17 9:21
 * @description: 会员签到Client
 */
@FeignClient(name = ServiceConstant.MEMBER_SERVICE, contextId = "memberSign",fallback = MemberSignFallback.class)
public interface MemberSignClient {

    /**
     * 会员签到
     *
     * @return 是否签到成功
     */
    @GetMapping("/feign/member/memberSign/memberSign")
    Boolean memberSign();

    /**
     * 根据时间查询签到数据
     * 主要是根据年月查询，给会员端日历展示数据
     *
     * @param time 时间 格式 YYYYmm
     * @return 会员签到列表
     */
    @GetMapping("/feign/member/memberSign/getMonthSignDay")
    List<MemberSign> getMonthSignDay(@RequestParam String time);

    /**
     * 会员签到赠送积分
     *
     * @param memberId 会员id
     * @param day      签到天数
     */
    @GetMapping("/feign/member/memberSign/memberSignSendPoint")
    void memberSignSendPoint(@RequestParam String memberId, @RequestParam Integer day);
}
