package cn.lili.modules.member.client;

import cn.lili.modules.constant.ServiceConstant;
import cn.lili.modules.member.fallback.MemberWalletFallback;
import cn.lili.modules.wallet.entity.dto.MemberWalletUpdateDTO;
import cn.lili.modules.wallet.entity.vo.MemberWalletVO;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

/**
 * 会员钱包业务
 *
 * @author liushuai(liushuai711 @ gmail.com)
 * @since 2021/12/7 08:24
 */
@FeignClient(
    name = ServiceConstant.MEMBER_SERVICE,
    contextId = "member-wallet",
    fallback = MemberWalletFallback.class)
public interface MemberWalletClient {

  /**
   * 查询会员的预存款
   *
   * @param memberId 会员id
   * @return 会员预存款VO
   */
  @GetMapping("/feign/member/wallet/query-by-member")
  MemberWalletVO getMemberWallet(@RequestParam String memberId);

  /**
   * 增加用户预存款余额
   *
   * @param memberWalletUpdateDTO 变动模型
   * @return 返回增加结果 true:成功 false:失败
   */
  @PutMapping("/feign/member/wallet/increase")
  Boolean increase(@RequestBody MemberWalletUpdateDTO memberWalletUpdateDTO);

  /**
   * 从冻结金额到余额
   *
   * @param memberWalletUpdateDTO 变动模型
   * @return 返回冻结结果 true:成功 false:失败
   */
  @PutMapping("/feign/member/wallet/increaseWithdrawal")
  Boolean increaseWithdrawal(@RequestBody MemberWalletUpdateDTO memberWalletUpdateDTO);

  /**
   * 扣减用户预存款余额
   *
   * @param memberWalletUpdateDTO 变动模型
   * @return 操作状态 true:成功 false:失败
   */
  @PutMapping("/feign/member/wallet/reduce")
  Boolean reduce(@RequestBody MemberWalletUpdateDTO memberWalletUpdateDTO);

  /**
   * 提现扣减余额到冻结金额
   *
   * @param memberWalletUpdateDTO 变动模型
   * @return 操作状态 true:成功 false:失败
   */
  @PutMapping("/feign/member/wallet/reduceWithdrawal")
  Boolean reduceWithdrawal(@RequestBody MemberWalletUpdateDTO memberWalletUpdateDTO);

  /**
   * 提现扣减冻结金额
   *
   * @param memberWalletUpdateDTO 变动模型
   * @return 操作状态
   */
  @PutMapping("/feign/member/wallet/reduceFrozen")
  Boolean reduceFrozen(@RequestBody MemberWalletUpdateDTO memberWalletUpdateDTO);

  @GetMapping("/feign/member/wallet/save")
  void save(@RequestParam String id, @RequestParam String username);

  /**
   * 提现公共方法
   *
   * @param withdrawApplyId 会员零钱提现Id
   * @return 操作状态
   */
  @GetMapping("/feign/member/wallet/withdrawal")
  Boolean withdrawal(@RequestParam String withdrawApplyId);
}
