package cn.lili.modules.member.client;

/**
 * MemberServiceClient
 *
 * @author Chopper
 * @version v1.0
 * 2021-11-29 12:07
 */

import cn.lili.modules.constant.ServiceConstant;
import cn.lili.modules.member.fallback.ShortLinkFallback;
import cn.lili.modules.message.entity.dos.ShortLink;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

import java.util.List;

/**
 * 短链接 业务client
 *
 * @author Chopper
 * @version v1.0
 * 2021-11-08 09:52
 */
@FeignClient(name = ServiceConstant.MEMBER_SERVICE, contextId = "short-link", fallback = ShortLinkFallback.class)
public interface ShortLinkClient {


    /**
     * 查询端链接集合
     */
    @PostMapping("/feign/member/short-link/list")
    List<ShortLink> queryShortLinks(@RequestBody ShortLink shortLink);

    /**
     * 保存短链接
     *
     * @param shortLink
     */
    @PostMapping("/feign/member/short-link/save")
    void save(@RequestBody ShortLink shortLink);

    @GetMapping("/feign/member/short-link/getById/{id}")
    ShortLink getById(@PathVariable String id);
}
