package cn.lili.modules.member.client;

import cn.lili.modules.constant.ServiceConstant;
import cn.lili.modules.member.entity.dto.StoreManagerDTO;
import cn.lili.modules.member.fallback.ShortLinkFallback;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;

/**
 * @Author yuquanfeng
 * @Date 2023/9/11
 * @Description
 **/

@FeignClient(name = ServiceConstant.MEMBER_SERVICE, contextId = "store-manager", fallback = ShortLinkFallback.class)
public interface StoreManagerClient {

    @GetMapping("/feign/member/store/manager/getByManagerId")
    List<StoreManagerDTO> getByManagerId(@RequestParam Long managerId);


    @PostMapping("/feign/member/store/manager/deleteByManagerIds")
    Boolean deleteByManagerId(@RequestBody List<Long> managerIds);

}
