package cn.lili.modules.member.fallback;

import cn.lili.common.enums.ResultCode;
import cn.lili.common.exception.ServiceException;
import cn.lili.common.security.enums.UserEnums;
import cn.lili.modules.member.client.MemberClient;
import cn.lili.modules.member.entity.dos.Member;
import cn.lili.modules.member.entity.dto.MemberSearchPageDTO;
import cn.lili.modules.member.entity.dto.MemberSearchParams;
import cn.lili.modules.member.entity.vo.MemberSearchVO;
import cn.lili.modules.member.entity.vo.MemberVO;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.stereotype.Component;

import java.util.List;
import java.util.Map;

/**
 * @author: ftyy
 * @date: 2022-01-13 15:46
 * @description: 会员服务 Fallback
 */
@Component
public class MemberFallback implements MemberClient {
    @Override
    public Member getById(String id) {
        throw new ServiceException(ResultCode.ERROR);
    }

    @Override
    public List<Map<String, Object>> listFieldsByMemberIds(String columns, List<String> memberIds) {
        throw new ServiceException(ResultCode.ERROR);
    }

    @Override
    public Member getByCache(String id) {
        return null;
    }

    @Override
    public void logout(UserEnums userEnums) {
        throw new ServiceException(ResultCode.ERROR);
    }

    @Override
    public List<String> getAllMemberMobile() {
        throw new ServiceException(ResultCode.ERROR);
    }

    @Override
    public long getMemberNum(MemberSearchVO memberSearchVO) {
        throw new ServiceException(ResultCode.ERROR);
    }

    @Override
    public List<Member> list(MemberSearchParams searchParams) {
        throw new ServiceException(ResultCode.ERROR);
    }

    @Override
    public Boolean updateMemberPoint(Long point, String type, String memberId, String content) {
        throw new ServiceException(ResultCode.ERROR);
    }

    /**
     * 更新会员登录时间为最新时间
     *
     * @param memberId 会员id
     * @return 是否更新成功
     */
    @Override
    public boolean updateMemberLoginTime(String memberId) {
        throw new ServiceException(ResultCode.ERROR);
    }

    @Override
    public Long getMemberPoint(String memberId) {
        throw new ServiceException(ResultCode.ERROR);
    }

    @Override
    public Page<MemberVO> getMemberPage(MemberSearchPageDTO memberSearchVO) {
        throw new ServiceException(ResultCode.ERROR);
    }
}
